#version 150

// This came from some tutorial, mentioning some drivers required this to function
//   properly but did not delve into why. 
precision highp float;

in  vec2 fragmentTextureUV;
in  vec4 fragmentColor;

out vec4 finalFragColor;

// diffuseTexture is a 2D texture sampler for diffuse texture.
uniform sampler2D diffuseTexture;

// colorMatrix will be an identity matrix for sprites and special for fonts
//   since fonts in GL 3.2 Core uses only RED channel on texture, multiply
//   by this matrix can convert that into argb for further use.
uniform mat4 colorMatrix;

// colorTint is an offset to keep the fonts from having a strange black edge
//   appearing around them that looks pretty bad.
uniform vec4 colorTint;
 
void main(void)
{
	//vec4 color = texture(diffuseTexture, fragmentTextureUV);
	//finalFragColor = colorMatrix * (color + colorTint);

	//finalFragColor = finalFragColor * fragmentColor;

	vec4 color = texture(diffuseTexture, fragmentTextureUV);
	finalFragColor = colorTint + (colorMatrix * color);
	finalFragColor = clamp(finalFragColor, vec4(0,0,0,0), vec4(1,1,1,1));
	finalFragColor = (finalFragColor) * fragmentColor;


	if (finalFragColor.a < 0.01)
	{
		discard;
	}
}