///
/// @file
/// @details An entity within the LudumDare35 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#ifndef _LudumDare35_ArtificialFighterEntity_h_
#define _LudumDare35_ArtificialFighterEntity_h_

#include "ludumdare35.h"
#include "fighter_entity.h"

namespace LudumDare35
{

	enum FighterState
	{
		kStateSpawn,
		kStateIdle,
		kStateWandering,
		kStateMove,
		kStateAttack,
		kStatePowerAttack,
	};

	enum FighterTarget
	{
		kTargetCenter,
		kTargetForward,
		kTargetBackward,
		kTargetLeft,
		kTargetRight,
		kMaximumTargets
	};

	class ArtificialFighterEntity : public FighterEntity
	{
	public:
		ArtificialFighterEntity(const tbMath::Vector2& spawnPosition, const FighterShape& fighterShape, const FighterState& spawnState = kStateSpawn);
		virtual ~ArtificialFighterEntity(void);

		static void SeparateArtificialFighters(tbGame::EntityManager& entityManager);

	protected:
		virtual void OnAdded(void) override;
		virtual void OnRemoved(void) override;
		virtual void OnSimulate(void) override;
		virtual void OnUpdate(const float deltaTime) override;
		virtual void OnRender(void) const override;
		virtual void OnCollideWith(tbGame::Entity& otherEntity) override;

	private:
		void ChangeToState(const FighterState& state);

		FighterState mState;
		tbGame::GameTimer mStateTimer;

		//Only valid in kStateWandering
		tbMath::Vector2 mWanderingPosition;

		//Only valid in kStateAttack
		bool mPowerAttack;

		FighterTarget mTargetArea;
	};

}; /* namespace LudumDare35 */

#endif /* _LudumDare35_ArtificialFighterEntity_h_ */
