///
/// @file
/// @details A way to store and set results, like current/best score for the LudumDare35 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#ifndef _LudumDare35_HealthBar_h_
#define _LudumDare35_HealthBar_h_

#include "ludumdare35.h"

#include <stdint.h>

namespace LudumDare35
{

	class HealthBar : public tbGraphics::GraphicList
	{
	public:
		HealthBar(const int maximumHealth);
		~HealthBar(void);

		int GetCurrentHealth(void) const { return mCurrentHealth; }
		int GetMaximumHealth(void) const { return mMaximumHealth; }
		bool IsAlive(void) const;
		bool Hurt(int amount);
		void Heal(int amount);

	private:
		void ResetGraphics(void);

		tbGraphics::BoxShape mOuterBox;
		tbGraphics::BoxShape mHurtBox;
		tbGraphics::BoxShape mInnerBox;

		int mMaximumHealth;
		int mCurrentHealth;
	};

}; /* namespace LudumDare35 */

#endif /* _LudumDare35_HealthBar_h_ */
