///
/// @file
/// @details Entry point of the LudumDare35 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#include "ludumdare35.h"
#include "scene_manager.h"

//--------------------------------------------------------------------------------------------------------------------//

int real_main(int argumentCount, const char* argumentValues[])
{
	tbGame::GameApplication gameApplication;
	gameApplication.SetWindowTitle(tb_string("LudumDare35"));

	tbGraphics::theSpriteManager.LoadSpriteSheetFromFile("concept_art", "data/concept_kit/concept_art_sheet.json");

	tbGraphics::theSpriteManager.LoadSpriteSheetFromFile("sword", "data/sword_sheet.json");

	tbGraphics::theSpriteManager.LoadSpriteSheetFromFile("fire_fighter_sheet", "data/fire_fighter_sheet.json");
	tbGraphics::theSpriteManager.LoadSpriteSheetFromFile("water_fighter_sheet", "data/water_fighter_sheet.json");
	tbGraphics::theSpriteManager.LoadSpriteSheetFromFile("earth_fighter_sheet", "data/earth_fighter_sheet.json");

	tbAudio::theAudioManager.LoadEventTable("concept_audio", "data/concept_kit/concept_audio_events.json");
	tbAudio::theAudioManager.LoadEventTable("audio_events", "data/audio/audio_events.json");

	LudumDare35::SceneManager::CreateSceneManager();

	gameApplication.RunGame(LudumDare35::SceneManager::GetScene(LudumDare35::kTitleScene));
	LudumDare35::SceneManager::DestroySceneManager();

	return 0;
}

//--------------------------------------------------------------------------------------------------------------------//

int main(const int argumentCount, const char* argumentValues[])
{
	tb_log_open("debug_log.txt", true);
	tb_log("Started Game: LudumDare35\n");

	int returnCode = tb_debug_project_entry_point_with(real_main, argumentCount, argumentValues);

	tb_log("Clean shutdown.\n");
	tb_log_close();
	return returnCode;
}

//--------------------------------------------------------------------------------------------------------------------//
