///
/// @file
/// @details An entity within the LudumDare35 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#ifndef _LudumDare35_PickupEntity_h_
#define _LudumDare35_PickupEntity_h_

#include "ludumdare35.h"

namespace LudumDare35
{

	class FighterEntity;

	class PickupEntity : public tbGame::Entity
	{
	public:
		PickupEntity(const tbMath::Vector2& spawnPosition, bool isFlying);
		virtual ~PickupEntity(void);

		bool CanPickup(void) const { return (true == mFlyingTimer.IsZero() &&  true == mSpawningTimer.IsZero()) ? true : false; }
		
		void OnPickup(FighterEntity& fighter);

	protected:
		virtual void OnAdded(void) override;
		virtual void OnRemoved(void) override;
		virtual void OnSimulate(void) override;
		virtual void OnUpdate(const float deltaTime) override;
		virtual void OnRender(void) const override;
		virtual void OnCollideWith(tbGame::Entity& otherEntity) override;

	private:
		void RandomizePickup(void);

		bool mIsHealthPickup;
		int mPickupAmount;
		bool mEndOfLifeFlash;
		
		tbGraphics::Sprite mSprite;
		tbGame::GameTimer mFlyingTimer;
		tbMath::Vector2 mStartFlyingPosition;
		tbMath::Vector2 mFinalFlyingPosition;

		tbGame::GameTimer mSpawningTimer;
		tbGame::GameTimer mLifeTimer;
	};

}; /* namespace LudumDare35 */

#endif /* _LudumDare35_PickupEntity_h_ */
