///
/// @file
/// @details An entity within the LudumDare35 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#include "player_fighter_entity.h"
#include "pickup_entity.h"

//--------------------------------------------------------------------------------------------------------------------//

LudumDare35::PlayerFighterEntity::PlayerFighterEntity(const tbMath::Vector2& spawnPosition) :
	FighterEntity(spawnPosition, kFighterTriangle)
{
	AddEntityType("Player");
	AddEntityType("Hero");

	mWalkingSpeed = 220.0f;
	mTurningSpeed = 240.0f;
}

//--------------------------------------------------------------------------------------------------------------------//

LudumDare35::PlayerFighterEntity::~PlayerFighterEntity(void)
{
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::PlayerFighterEntity::OnAdded(void)
{
	FighterEntity::OnAdded();
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::PlayerFighterEntity::OnRemoved(void)
{
	FighterEntity::OnRemoved();
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::PlayerFighterEntity::OnSimulate(void)
{
	FighterEntity::OnSimulate();

	//tbGraphics::GetActiveCamera().SetPosition(GetPosition() - tbGraphics::ScreenCenter());

	tbGraphics::GetActiveCamera().SetPosition((GetPosition() * 0.5f) - tbGraphics::ScreenCenter());

}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::PlayerFighterEntity::OnUpdate(const float deltaTime)
{
	FighterEntity::OnUpdate(deltaTime);

	//int mouseX(0);
	//int mouseY(0);
	//tbApplication::Input::GetMousePosition(&mouseX, &mouseY);
	//tbMath::Vector2 mousePosition(static_cast<float>(mouseX), static_cast<float>(mouseY));
	//
	//mIsLockedOnTarget = true;
	//mTargetPosition = mousePosition + tbGraphics::GetActiveCamera().GetPosition();

	//mIsWalkingForward = tbApplication::Input::IsKeyDown(tbApplication::tbKeyW) || tbApplication::Input::IsKeyDown(tbApplication::tbKeyUp);
	//mIsWalkingBackward = tbApplication::Input::IsKeyDown(tbApplication::tbKeyS) || tbApplication::Input::IsKeyDown(tbApplication::tbKeyDown);
	//mIsStrafingLeft = tbApplication::Input::IsKeyDown(tbApplication::tbKeyA) || tbApplication::Input::IsKeyDown(tbApplication::tbKeyLeft);
	//mIsStrafingRight = tbApplication::Input::IsKeyDown(tbApplication::tbKeyD) || tbApplication::Input::IsKeyDown(tbApplication::tbKeyRight);

	AutoLockOnTarget();

	mIsMovingNorth = tbApplication::Input::IsKeyDown(tbApplication::tbKeyW) || tbApplication::Input::IsKeyDown(tbApplication::tbKeyUp);
	mIsMovingSouth = tbApplication::Input::IsKeyDown(tbApplication::tbKeyS) || tbApplication::Input::IsKeyDown(tbApplication::tbKeyDown);
	mIsMovingWest = tbApplication::Input::IsKeyDown(tbApplication::tbKeyA) || tbApplication::Input::IsKeyDown(tbApplication::tbKeyLeft);
	mIsMovingEast = tbApplication::Input::IsKeyDown(tbApplication::tbKeyD) || tbApplication::Input::IsKeyDown(tbApplication::tbKeyRight);
	mIsAttacking = tbApplication::Input::IsKeyDown(tbApplication::tbMouseLeft) || tbApplication::Input::IsKeyDown(tbApplication::tbKeyZ);

	mAttemptShapeShift = tbApplication::Input::IsKeyPressed(tbApplication::tbKeySpace) || mAttemptShapeShift;
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::PlayerFighterEntity::OnRender(void) const
{
	FighterEntity::OnRender();
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::PlayerFighterEntity::OnCollideWith(tbGame::Entity& otherEntity)
{
	FighterEntity::OnCollideWith(otherEntity);

	if (true == otherEntity.IsEntityOfType("PickupEntity"))
	{
		PickupEntity* pickup(dynamic_cast<PickupEntity*>(&otherEntity));
		if (nullptr != pickup)
		{
			pickup->OnPickup(*this);
		}
	}
}

//--------------------------------------------------------------------------------------------------------------------//
