///
/// @file
/// @details An entity within the LudumDare35 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#ifndef _LudumDare35_PlayerFighterEntity_h_
#define _LudumDare35_PlayerFighterEntity_h_

#include "ludumdare35.h"
#include "fighter_entity.h"

namespace LudumDare35
{

	class PlayerFighterEntity : public FighterEntity
	{
	public:
		PlayerFighterEntity(const tbMath::Vector2& spawnPosition);
		virtual ~PlayerFighterEntity(void);

	protected:
		virtual void OnAdded(void) override;
		virtual void OnRemoved(void) override;
		virtual void OnSimulate(void) override;
		virtual void OnUpdate(const float deltaTime) override;
		virtual void OnRender(void) const override;
		virtual void OnCollideWith(tbGame::Entity& otherEntity) override;

	private:
	};

}; /* namespace LudumDare35 */

#endif /* _LudumDare35_PlayerFighterEntity_h_ */
