///
/// @file
/// @details Contains all of the scenes in the LudumDare35 project from splash, menus, options, 
///   to gameplay to provide an  easy way for the scenes to be managed and changed between.
///   (Although TurtleBrains supplies a way to change between GameScene's it doesn't provide a great way to manage their memory.)
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#include "scene_manager.h"
#include "gameplay_scene.h"
#include "title_scene.h"

LudumDare35::SceneManager* LudumDare35::theSceneManager(nullptr);

//--------------------------------------------------------------------------------------------------------------------//

LudumDare35::SceneManager::SceneManager(void)
{
	//The scenes
	mScenes.resize(kSceneCount, nullptr);
	mScenes[kGameplayScene] = new GameplayScene();
	mScenes[kTitleScene] = new TitleScene();
}

//--------------------------------------------------------------------------------------------------------------------//

LudumDare35::SceneManager::~SceneManager(void)
{
	while (false == mScenes.empty())
	{
		delete mScenes.back();
		mScenes.pop_back();
	}
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::SceneManager::CreateSceneManager(void)
{
	tb_error_if(nullptr != theSceneManager, "Expected theSceneManager to be null when calling create, seems create has been called twice.");
	theSceneManager = new SceneManager();
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::SceneManager::DestroySceneManager(void)
{
	tb_error_if(nullptr == theSceneManager, "Expected theSceneManager to be a valid pointer when calling destroy, seems destroy has been called twice, or without create.");
	delete theSceneManager;
	theSceneManager = nullptr;
}

//--------------------------------------------------------------------------------------------------------------------//

tbGame::GameScene& LudumDare35::SceneManager::GetScene(const SceneId& sceneIdentifier)
{
	tb_error_if(nullptr == theSceneManager, "Expected theSceneManager to be created and valid before ChangeToScene is called.");
	tb_error_if(sceneIdentifier < 0, "Expected a valid sceneIdentifier, below zero is out of range.");
	tb_error_if(static_cast<size_t>(sceneIdentifier) >= theSceneManager->mScenes.size(), "Expected a valid sceneIdentifier, out of range.  Was the scene added to manager?");
	return *theSceneManager->mScenes[sceneIdentifier];
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::SceneManager::ChangeToScene(const SceneId& sceneIdentifier)
{
	tbGame::GameScene::ChangeToScene(SceneManager::GetScene(sceneIdentifier));
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::SceneManager::QuitGame(void)
{
	tb_error_if(nullptr == theSceneManager, "Expected theSceneManager to be created and valid before ChangeToScene is called.");
	tbGame::GameApplication::MarkForClose();
}

//--------------------------------------------------------------------------------------------------------------------//
