///
/// @file
/// @details An entity within the LudumDare35 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#include "score_display.h"
#include "game_results.h"

//--------------------------------------------------------------------------------------------------------------------//

LudumDare35::ScoreDisplay::ScoreDisplay(void) :
	tbGame::Entity("ScoreDisplay")
{
	mScoreText.SetScroll(0.0f);
	AddGraphic(mScoreText);

	mBestScoreText.SetScroll(0.0f);
	AddGraphic(mBestScoreText);
}

//--------------------------------------------------------------------------------------------------------------------//

LudumDare35::ScoreDisplay::~ScoreDisplay(void)
{
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::ScoreDisplay::OnAdded(void)
{
	tbGame::Entity::OnAdded();
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::ScoreDisplay::OnRemoved(void)
{
	tbGame::Entity::OnRemoved();
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::ScoreDisplay::OnSimulate(void)
{
	tbGame::Entity::OnSimulate();
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::ScoreDisplay::OnUpdate(const float deltaTime)
{
	tbGame::Entity::OnUpdate(deltaTime);

	mScoreText.SetText("Score: " + tbCore::ToString(LudumDare35::GameResults::GetCurrentScore()));
	mScoreText.SetPosition(20.0f, 20.0f);

	mBestScoreText.SetText("Best: " + tbCore::ToString(LudumDare35::GameResults::GetBestScore()));
	mBestScoreText.SetPosition(tbGraphics::ScreenWidth() - (20.0f + mBestScoreText.GetWidth()), 20.0f);
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::ScoreDisplay::OnRender(void) const
{
	tbGame::Entity::OnRender();
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::ScoreDisplay::OnCollideWith(tbGame::Entity& otherEntity)
{
	tbGame::Entity::OnCollideWith(otherEntity);
}

//--------------------------------------------------------------------------------------------------------------------//
