///
/// @file
/// @details An entity within the LudumDare35 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#include "score_entity.h"
#include "game_results.h"

//--------------------------------------------------------------------------------------------------------------------//

LudumDare35::ScoreEntity::ScoreEntity(const tbMath::Vector2& spawnPosition, int score) :
	tbGame::Entity("ScoreEntity"),
	mScoreText(tb_string((score > 0) ? "+" : "-") + tb_string(score), 20.0f),
	mLifeTimer(1500)
{
	mScoreText.SetColor(tbGraphics::Color(0xFF995200));

	SetPosition(spawnPosition);
	AddGraphic(mScoreText);
}

//--------------------------------------------------------------------------------------------------------------------//

LudumDare35::ScoreEntity::~ScoreEntity(void)
{
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::ScoreEntity::OnAdded(void)
{
	tbGame::Entity::OnAdded();
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::ScoreEntity::OnRemoved(void)
{
	tbGame::Entity::OnRemoved();
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::ScoreEntity::OnSimulate(void)
{
	tbGame::Entity::OnSimulate();

	if (true == mLifeTimer.DecrementStep())
	{
		SetPosition(GetPosition() + (tbMath::Vector2(0.0f, -100.0f) * kFixedTime));

		GetEntityManager()->RemoveEntity(this);
	}
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::ScoreEntity::OnUpdate(const float deltaTime)
{
	tbGame::Entity::OnUpdate(deltaTime);
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::ScoreEntity::OnRender(void) const
{
	tbGame::Entity::OnRender();
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::ScoreEntity::OnCollideWith(tbGame::Entity& otherEntity)
{
	tbGame::Entity::OnCollideWith(otherEntity);
}

//--------------------------------------------------------------------------------------------------------------------//
