///
/// @file
/// @details An entity within the LudumDare35 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#ifndef _LudumDare35_ScoreEntity_h_
#define _LudumDare35_ScoreEntity_h_

#include "ludumdare35.h"

namespace LudumDare35
{

	class ScoreEntity : public tbGame::Entity
	{
	public:
		ScoreEntity(const tbMath::Vector2& spawnPosition, const int score);
		virtual ~ScoreEntity(void);

	protected:
		virtual void OnAdded(void) override;
		virtual void OnRemoved(void) override;
		virtual void OnSimulate(void) override;
		virtual void OnUpdate(const float deltaTime) override;
		virtual void OnRender(void) const override;
		virtual void OnCollideWith(tbGame::Entity& otherEntity) override;

	private:
		tbGraphics::Text mScoreText;
		tbGame::GameTimer mLifeTimer;
	};

}; /* namespace LudumDare35 */

#endif /* _LudumDare35_ScoreEntity_h_ */
