///
/// @file
/// @details An entity within the LudumDare35 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#include "shifter_entity.h"

const float kShifterScale(0.25f);

//--------------------------------------------------------------------------------------------------------------------//

LudumDare35::ShifterEntity::ShifterEntity(const tbMath::Vector2& spawnPosition) :
	tbGame::Entity("ShifterEntity"),
	mSprite("data/shifter.png")
{
	mSprite.SetOrigin(tbGraphics::kAnchorCenter);
	mSprite.SetScale(kShifterScale);
	AddGraphic(mSprite);

	SetPosition(spawnPosition);	
	AddBoundingCircle(mSprite.GetWidth() * kShifterScale);	
}

//--------------------------------------------------------------------------------------------------------------------//

LudumDare35::ShifterEntity::~ShifterEntity(void)
{
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::ShifterEntity::OnAdded(void)
{
	tbGame::Entity::OnAdded();
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::ShifterEntity::OnRemoved(void)
{
	tbGame::Entity::OnRemoved();
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::ShifterEntity::OnSimulate(void)
{
	tbGame::Entity::OnSimulate();
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::ShifterEntity::OnUpdate(const float deltaTime)
{
	tbGame::Entity::OnUpdate(deltaTime);
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::ShifterEntity::OnRender(void) const
{
	tbGame::Entity::OnRender();
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::ShifterEntity::OnCollideWith(tbGame::Entity& otherEntity)
{
	tbGame::Entity::OnCollideWith(otherEntity);
}

//--------------------------------------------------------------------------------------------------------------------//
