///
/// @file
/// @details An entity within the LudumDare35 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#ifndef _LudumDare35_TemplateEntity_h_
#define _LudumDare35_TemplateEntity_h_

#include "ludumdare35.h"

namespace LudumDare35
{

	class TemplateEntity : public tbGame::Entity
	{
	public:
		TemplateEntity(void);
		virtual ~TemplateEntity(void);

	protected:
		virtual void OnAdded(void) override;
		virtual void OnRemoved(void) override;
		virtual void OnSimulate(void) override;
		virtual void OnUpdate(const float deltaTime) override;
		virtual void OnRender(void) const override;
		virtual void OnCollideWith(tbGame::Entity& otherEntity) override;

	private:
		tbGraphics::Sprite mSprite;
	};

}; /* namespace LudumDare35 */

#endif /* _LudumDare35_TemplateEntity_h_ */
