///
/// @file
/// @details This file contains implementation details specific to TurtleBrains and may be modified without warning.
/// @note using any classes, functions or definitions found within TurtleBrains::Implementation / tbImplementation is
///   not recommended as they can be changed or removed completely without warning.  This is your final warning.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved --> 
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrainsImplementation_ApplicationInformation_h_
#define _TurtleBrainsImplementation_ApplicationInformation_h_

#include "../../core/tb_configuration.h"

#if defined(tb_windows)
	#define WIN32_LEAN_AND_MEAN
	#include <Windows.h>
#elif defined(tb_macosx)
  #ifdef __OBJC__
	  @class NSApplication;
	#else
	  struct NSApplication;
  #endif
#elif defined(tb_linux)
#else
	#error This configuration is currently unsupported by TurtleBrains.
#endif /* tb_configuration */

namespace tbImplementation
{
	struct WindowInformation
	{
#if defined(tb_windows)
		HWND mWindowHandle;
#elif defined(tb_macosx)
		NSApplication* mApplication;
#elif defined(tb_linux)
		int unknown;
#else
	#error This configuration is currently unsupported by TurtleBrains.
#endif /* tb_configuration */
	};
};	/* namespace tbImplementation */

#endif /* _TurtleBrainsImplementation_ApplicationInformation_h_ */
