///
/// @file
///	@details This file contains implementation details specific to TurtleBrains and may be modified without warning.
///	@note using any classes, functions or definitions found within TurtleBrains::Implementation / tbImplementation is
///	not recommended as they can be changed or removed completely without warning.  This is your final warning.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved --> 
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrainsImplementation_ApplicationMenu_h_
#define _TurtleBrainsImplementation_ApplicationMenu_h_

#include "../tb_application_menu.h"
#include "tbi_application_information.h"

//The following system specific implementation details can be found in tb_system_application_menu.cpp

namespace tbImplementation
{
	///
	///	Internal Documentation is useful too, lets write this sometime.
	///
	struct MenuItem
	{
			std::vector<MenuItem> mSubItems;
			tbCore::tbString mDisplayName;
			tbApplication::MenuItemIdentifier mItemIdentifier;
			bool mIsEnabled;
			bool mIsChecked;
			bool mIsVisible;
	};

	///
	///	Internal Documentation is useful too, lets write this sometime.
	///
	bool IsMenuItemSafeForDuplication(const tbApplication::MenuItemIdentifier& itemIdentifier);

	///
	///	Internal Documentation is useful too, lets write this sometime.
	///
	void SetMenuItemSafeForDuplication(const tbApplication::MenuItemIdentifier& itemIdentifier);

	///
	///	Internal Documentation is useful too, lets write this sometime.
	///
	MenuItem& CreateMenuItem(const tbApplication::MenuIdentifier& menuIdentifier, const tbApplication::MenuItemIdentifier& itemIdentifier,
		const tbCore::tbString& displayName, const tbApplication::MenuItemIdentifier& parentIdentifier, bool isEnabled, bool isChecked, bool isVisible);

	///
	///	Internal Documentation is useful too, lets write this sometime.
	///
	void DestroyMenuItem(const tbApplication::MenuIdentifier& menuIdentifier);

	///
	///	Internal Documentation is useful too, lets write this sometime.
	///
	MenuItem& GetMenuFor(const tbApplication::MenuIdentifier& menuIdentifier);

	///
	///	Internal Documentation is useful too, lets write this sometime.
	///
	MenuItem* GetMenuItem(const tbApplication::MenuIdentifier& menuIdentifier, const tbApplication::MenuItemIdentifier& itemIdentifier);

	///
	///	Internal Documentation is useful too, lets write this sometime.
	///
	MenuItem& GetMenuItemReference(const tbApplication::MenuIdentifier& menuIdentifier, const tbApplication::MenuItemIdentifier& itemIdentifier);

	/////
	/////	Internal Documentation is useful too, lets write this sometime.
	/////
	//MenuItem& GetMenuItemByIndex(const tbApplication::MenuIdentifier& menuIdentifier, const size_t& itemIndex);

	/////
	/////	Internal Documentation is useful too, lets write this sometime.
	/////
	//size_t NumberOfItemsForMenu(const tbApplication::MenuIdentifier& menuIdentifier);





	///
	///	This has a 96% chance of being deprecated as it currently assumes the Active Window is the window to add the Menu to.  Use instead the function below.
	///
	void SetWindowMenu(const TurtleBrains::Application::ApplicationMenu& menu, TurtleBrains::Application::ApplicationHandlerInterface& menuHandler);

	///
	///	@details Add a menu to the Window for the user to interact with.
	///
	///	@note This function is incomplete and will be deprecated before v1 of TurtleBrains release once void* is
	///	handled in a much more typesafe manner.  TurtleBrains has a 0 tolerance for void* and this will be removed!
	///
	///	@param windowInformation		The information required to attached the Menu to the window.
	///	@param menu						The menu to be applied to the window.
	///
	void SetWindowMenu(WindowInformation& windowInformation, const TurtleBrains::Application::ApplicationMenu& menu, TurtleBrains::Application::ApplicationHandlerInterface& menuHandler);

	///
	///	Cleanup after adding a menu to the window.
	///
	void CleanupWindowMenu(TurtleBrains::Application::ApplicationHandlerInterface& menuHandler);

	///
	///
	///
	void SetContextMenu(const TurtleBrains::Application::ApplicationMenu& menu, TurtleBrains::Application::ApplicationHandlerInterface& menuHandler);
	
	///
	///
	///
	void SetContextMenu(WindowInformation& windowInformation, const TurtleBrains::Application::ApplicationMenu& menu, TurtleBrains::Application::ApplicationHandlerInterface& menuHandler);
	
	///
	///	Cleanup after adding a context menu to the window.
	///
	void CleanupContextMenu(TurtleBrains::Application::ApplicationHandlerInterface& menuHandler);

};	/* namespace tbImplementation */

#endif /* _TurtleBrainsImplementation_ApplicationMenu_h_ */
