///
/// @file
/// @details This file contains implementation details specific to TurtleBrains and may be modified without warning.
/// @note using any classes, functions or definitions found within TurtleBrains::Implementation / tbImplementation is
///   not recommended as they can be changed or removed completely without warning.  This is your final warning.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved --> 
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrainsImplementation_ApplicationStatus_h_
#define _TurtleBrainsImplementation_ApplicationStatus_h_

#include "tbi_application_information.h"
#include "../tb_application_status.h"

namespace TurtleBrains
{
	namespace Application
	{
		class ApplicationHandlerInterface;
		class ApplicationStatus;
	};	/* namespace Application */
};	/* namespace TurtleBrains */

//The following system specific implementation details can be found in tb_system_application_menu.cpp

namespace tbImplementation
{

	///
	/// Internal Documentation Required
	///
	typedef std::pair<tbCore::tbString, char> StatusItem;

	///
	/// @details Retrieves the number of items that have been added to the state bar.
	///
	/// Currently defined in tb_application_status, as with the rest of the common Status implementation details.
	///
	void GetStatusItems(const tbApplication::StatusIdentifier& statusIdentifier, std::vector<StatusItem>& items);

	///
	/// Internal Documentation Required
	///
	typedef std::map<tbApplication::StatusItemIdentifier, StatusItem> StatusItemTable;

	///
	/// Internal Documentation Required
	///
	typedef std::map<tbApplication::StatusIdentifier, StatusItemTable> StatusTable;

	///
	/// Internal Documentation Required
	///
	///	This has a 96% chance of being deprecated as it currently assumes the Active Window is the window to add the Menu to.  Use instead the function below.
	///
	void SetWindowStatus(const TurtleBrains::Application::ApplicationStatus& status, TurtleBrains::Application::ApplicationHandlerInterface& menuHandler);

	///
	/// Internal Documentation Required
	///
	///	This has a 100% chance of being modified, primarily the input of the first parameter which currently takes a void pointer.  TurtleBrains will have a
	///	zero-tolerance for void* and non-typesafe code, period.
	///
	void SetWindowStatus(WindowInformation& windowInformation, const TurtleBrains::Application::ApplicationStatus& status, TurtleBrains::Application::ApplicationHandlerInterface& menuHandler);

	///
	///	Cleanup after adding a menu to the window.
	///
	void CleanupWindowStatus(TurtleBrains::Application::ApplicationHandlerInterface& menuHandler);

};	/* namespace tbImplementation */

#endif /* _TurtleBrainsImplementation_ApplicationStatus_h_ */
