///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrains_ApplicationInput_h_
#define _TurtleBrains_ApplicationInput_h_

#include <vector>

#include "../core/tb_types.h"

namespace TurtleBrains
{
	namespace Application
	{

		///
		/// @details Each Key supported by the TurtleBrains input system has a unique value for checking the status of
		///   the Key.  Supported keys: 0 through 9 on the top of the Keyboard, A through Z, Up, Down, Left, Right arrows,
		///   the Space, Enter and Escape keys.  Left, Middle and Right mouse buttons.
		///
		enum Key
		{
			tbKey0, tbKey1, tbKey2, tbKey3, tbKey4, tbKey5, tbKey6, tbKey7, tbKey8, tbKey9,
			tbKeyA, tbKeyB, tbKeyC, tbKeyD, tbKeyE, tbKeyF, tbKeyG, tbKeyH, tbKeyI, tbKeyJ,
			tbKeyK, tbKeyL, tbKeyM, tbKeyN, tbKeyO, tbKeyP, tbKeyQ, tbKeyR, tbKeyS, tbKeyT,
			tbKeyU, tbKeyV, tbKeyW, tbKeyX, tbKeyY, tbKeyZ, tbKeySpace, tbKeyEscape, tbKeyEnter,
			tbKeyUp, tbKeyDown, tbKeyLeft, tbKeyRight, tbMouseLeft, tbMouseRight, tbMouseMiddle, tbKeyMax
		};

		//
		// TODO: TIM: Planning: Do we need this?  The idea was that we would post events to the RealtimeApplication.
		//
		//enum InputEvent
		//{
		//	kPressedEvent,
		//	kReleasedEvent,
		//	//kRepeatEvent,
		//	kMoveEvent,
		//};

		namespace Input
		{
			///
			/// @details Checks to see if a Key was just pressed, meaning it was up during the last frame and is now
			///   down for the current frame.  If this condition is not satified, false will be returned, even if the
			///   key is currently down.
			///
			/// @param key Which key to check if it is being pressed.
			///
			bool IsKeyPressed(const Key& key);

			///
			/// @details Checks to see if a Key was just released, meaning it was down during the last frame and is now
			///   up for the current frame.  If this condition is not satified, false will be returned, even if the
			///   key is currently up.
			///
			/// @param key Which key to check if it is being release.
			///
			bool IsKeyReleased(const Key& key);

			///
			/// @details Returns true if the status of the key is currently down, or false if it is currently up.  This
			///   does not check the status of the key during the previous frame.
			///
			/// @param key Which key to check if it is down.
			///
			bool IsKeyDown(const Key& key);

			///
			/// @details Returns the position of the mouse from the top-left edge of the game window.  The values may
			///   be negative if the mouse is left or above the game window.
			///
			/// @param mouseX an integer to store the position of the mouse, in pixels, horizontally.
			/// @param mouseY an integer to store the position of the mouse, in pixels, vertically.
			///
			void GetMousePosition(int* mouseX, int* mouseY);

			///
			/// @details Returns true if the mouse has moved along with the the distance in pixels that the mouse had
			///   moved since the last frame, 0,0 would represent no movement and the function will return false.
			///
			/// @param mouseX an integer to store the distance the mouse moved, in pixels, horizontally.
			/// @param mouseY an integer to store the distance the mouse moved, in pixels, vertically.
			///
			bool GetMouseMovement(int* mouseX, int* mouseY);

			///
			/// @details Sets the mouse position to a specific location in pixels from the top-left edge of the game
			///   window.  0,0 being the top-left corner.
			///
			/// @param mouseX The horizontal position of the mouse in pixels from the left edge of the game window.
			/// @param mouseY The horizontal position of the mouse in pixels from the top edge of the game window.
			///
			void SetMousePosition(int mouseX, int mouseY);

		}; /* namespace Input */

	}; /* namespace Application */
}; /* namespace TurtleBrains */

namespace tbApplication = TurtleBrains::Application;

#endif /* _TurtleBrains_ApplicationMenu_h_ */
