///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved --> 
///------------------------------------------------------------------------------------------------------------------///

#include "tb_application_menu.h"
#include "../core/tb_error.h"
#include "../core/tb_string.h"

#include "implementation/tbi_system_application_menu.h"

#include <map>

namespace tbImplementation
{

	typedef std::map<tbApplication::MenuIdentifier, MenuItem> MenuTable;
	extern MenuTable tbiMenuTable;

};	/* namespace tbImplementation */

const tbApplication::MenuItemIdentifier tbApplication::kInvalidMenuItemIdentifier(0xFFFF);

//--------------------------------------------------------------------------------------------------------------------//

tbApplication::ApplicationMenu::ApplicationMenu(const MenuIdentifier& menuIdentifier) :
  mIdentifier(menuIdentifier)
{
	tbImplementation::MenuItem defaultItem;
	tbImplementation::tbiMenuTable.insert(tbImplementation::MenuTable::value_type(menuIdentifier, defaultItem));
}

//--------------------------------------------------------------------------------------------------------------------//

tbApplication::ApplicationMenu::~ApplicationMenu(void)
{
}

//--------------------------------------------------------------------------------------------------------------------//

const tbApplication::MenuIdentifier& tbApplication::ApplicationMenu::GetIdentifier(void) const
{
	return mIdentifier;
}

//--------------------------------------------------------------------------------------------------------------------//
//
//tbApplication::ApplicationMenu& tbApplication::ApplicationMenu::AddMenuItem(const tbCore::tbString& displayName, const MenuItemIdentifier& itemIdentifier, 
//                                                              const bool isEnabled, const bool isChecked, const bool isVisible)
//{
//	//tbImplementation::MenuItem& menuItem = tbImplementation::tbiMenuTable[mIdentifier];
//
//	//tbImplementation::MenuItem newMenuItem;
//	//newMenuItem.mDisplayName = displayName;
//	//newMenuItem.mIsEnabled = isEnabled;
//	//newMenuItem.mIsChecked = isChecked;
//	//newMenuItem.mIsVisible = isVisible;
//	//newMenuItem.mIdentifier = itemIdentifier;
//	//menuItem.mSubItems.push_back(newMenuItem);
//
//	//return *this;
//
//	mSubItems.push_back(ApplicationMenu());
//
//	ApplicationMenu& menuItem = mSubItems.back();
//	menuItem.SetDisplayName(displayName);
//	menuItem.SetEnabled(isEnabled);
//	menuItem.SetChecked(isChecked);
//	menuItem.SetVisible(isVisible);
//	menuItem.mIdentifier = itemIdentifier;
//	return menuItem;
//}

//--------------------------------------------------------------------------------------------------------------------//

void tbApplication::ApplicationMenu::AddMenuItem(const MenuItemIdentifier& itemIdentifier, const tbCore::tbString& displayName,
					const MenuItemIdentifier& parentIdentifier, const bool isEnabled, const bool isChecked, const bool isVisible)
{
	tbImplementation::CreateMenuItem(mIdentifier, itemIdentifier, displayName, parentIdentifier, isEnabled, isChecked, isVisible);
}

//--------------------------------------------------------------------------------------------------------------------//

const tbCore::tbString& tbApplication::ApplicationMenu::GetDisplayName(const MenuItemIdentifier& itemIdentifier) const
{
	return tbImplementation::GetMenuItemReference(mIdentifier, itemIdentifier).mDisplayName;
}

bool tbApplication::ApplicationMenu::IsEnabled(const MenuItemIdentifier& itemIdentifier) const
{
	return tbImplementation::GetMenuItemReference(mIdentifier, itemIdentifier).mIsEnabled;
}

bool tbApplication::ApplicationMenu::IsChecked(const MenuItemIdentifier& itemIdentifier) const
{
	return tbImplementation::GetMenuItemReference(mIdentifier, itemIdentifier).mIsChecked;
}

bool tbApplication::ApplicationMenu::IsVisible(const MenuItemIdentifier& itemIdentifier) const
{
	return tbImplementation::GetMenuItemReference(mIdentifier, itemIdentifier).mIsVisible;
}

//--------------------------------------------------------------------------------------------------------------------//

void tbApplication::ApplicationMenu::SetDisplayName(const MenuItemIdentifier& itemIdentifier, const tbCore::tbString& displayName)
{
	tbImplementation::GetMenuItemReference(mIdentifier, itemIdentifier).mDisplayName = displayName;
}

void tbApplication::ApplicationMenu::SetEnabled(const MenuItemIdentifier& itemIdentifier, bool isEnabled)
{
	tbImplementation::GetMenuItemReference(mIdentifier, itemIdentifier).mIsEnabled = isEnabled;
}

void tbApplication::ApplicationMenu::SetChecked(const MenuItemIdentifier& itemIdentifier, bool isChecked)
{
	tbImplementation::GetMenuItemReference(mIdentifier, itemIdentifier).mIsChecked = isChecked;
}

void tbApplication::ApplicationMenu::SetVisible(const MenuItemIdentifier& itemIdentifier, bool isVisible)
{
	tbImplementation::GetMenuItemReference(mIdentifier, itemIdentifier).mIsVisible = isVisible;
}

//--------------------------------------------------------------------------------------------------------------------//

void tbApplication::ApplicationMenu::SetItemSafeForDuplication(const MenuItemIdentifier& itemIdentifier)
{
	tbImplementation::SetMenuItemSafeForDuplication(itemIdentifier);
}

//--------------------------------------------------------------------------------------------------------------------//




//--------------------------------------------------------------------------------------------------------------------//
//--------------------------------------------------------------------------------------------------------------------//
//--------------------------------------------------------------------------------------------------------------------//

////--------------------------------------------------------------------------------------------------------------------//
//
//const tbApplication::MenuItemIdentifier& tbApplication::ApplicationMenu::GetIdentifier(void) const { return mIdentifier; }
//const tbCore::tbString& tbApplication::ApplicationMenu::GetDisplayName(void) const { return mDisplayName; }
//bool tbApplication::ApplicationMenu::IsEnabled(void) const { return mIsEnabled; }
//bool tbApplication::ApplicationMenu::IsChecked(void) const { return mIsChecked; }
//bool tbApplication::ApplicationMenu::IsVisible(void) const { return mIsVisible; }
//
////--------------------------------------------------------------------------------------------------------------------//
//
//void tbApplication::ApplicationMenu::SetDisplayName(const tbCore::tbString& displayName) { mDisplayName = displayName; }
//void tbApplication::ApplicationMenu::SetEnabled(const bool isEnabled) { mIsEnabled = isEnabled; }
//void tbApplication::ApplicationMenu::SetChecked(const bool isChecked) { mIsChecked = isChecked; }
//void tbApplication::ApplicationMenu::SetVisible(const bool isVisible) { mIsVisible = isVisible; }
//
////--------------------------------------------------------------------------------------------------------------------//
//
//size_t tbApplication::ApplicationMenu::Size(void) const
//{
//	return mSubItems.size();
//}
//
////--------------------------------------------------------------------------------------------------------------------//
//
//const tbApplication::ApplicationMenu& tbApplication::ApplicationMenu::GetItemAtIndex(const size_t itemIndex) const
//{
//	tb_error_if(itemIndex >= Size(), "itemIndex out of range, expected 0 <= itemIndex <= Size(%d)", Size());
//	return mSubItems[itemIndex];
//}
//
////--------------------------------------------------------------------------------------------------------------------//
//
//const tbApplication::ApplicationMenu* tbApplication::ApplicationMenu::GetMenuItem(const tbApplication::MenuItemIdentifier& itemIdentifier) const
//{
//	if (GetIdentifier() == itemIdentifier)
//	{
//		return this;
//	}
//
//	for (size_t index(0); index < Size(); ++index)
//	{
//		if (itemIdentifier == mSubItems[index].GetIdentifier())
//		{
//			return &mSubItems[index];
//		}
//	}
//
//	const tbApplication::ApplicationMenu* menuItem(nullptr);
//	for (size_t index(0); index < Size(); ++index)
//	{
//		menuItem = mSubItems[index].GetMenuItem(itemIdentifier);
//		if (nullptr != menuItem)
//		{
//			return menuItem;
//		}
//	}
//
//	return nullptr;
//}
//
////--------------------------------------------------------------------------------------------------------------------//
//
//tbApplication::ApplicationMenu* tbApplication::ApplicationMenu::GetMenuItem(const tbApplication::MenuItemIdentifier& itemIdentifier)
//{
//	if (GetIdentifier() == itemIdentifier)
//	{
//		return this;
//	}
//
//	for (size_t index(0); index < Size(); ++index)
//	{
//		if (itemIdentifier == mSubItems[index].GetIdentifier())
//		{
//			return &mSubItems[index];
//		}
//	}
//
//	tbApplication::ApplicationMenu* menuItem(nullptr);
//	for (size_t index(0); index < Size(); ++index)
//	{
//		menuItem = mSubItems[index].GetMenuItem(itemIdentifier);
//		if (nullptr != menuItem)
//		{
//			return menuItem;
//		}
//	}
//
//	return nullptr;
//}
//
////--------------------------------------------------------------------------------------------------------------------//
