///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved --> 
///------------------------------------------------------------------------------------------------------------------///

#include "tb_application_status.h"
#include "implementation/tbi_system_application_status.h"
#include "../core/tb_error.h"

const size_t kMaximumStatusItems(16);

namespace tbImplementation
{

	StatusTable tbiStatusTable;

};	/* namespace tbImplementation */

//--------------------------------------------------------------------------------------------------------------------//

tbApplication::ApplicationStatus::ApplicationStatus(const StatusIdentifier& statusIdentifier) :
	mIdentifier(statusIdentifier)
{
	tbImplementation::StatusItemTable defaultValue;
	tbImplementation::tbiStatusTable.insert(tbImplementation::StatusTable::value_type(statusIdentifier, defaultValue));
}

//--------------------------------------------------------------------------------------------------------------------//

tbApplication::ApplicationStatus::~ApplicationStatus(void)
{
}

//--------------------------------------------------------------------------------------------------------------------//

const tbApplication::StatusIdentifier& tbApplication::ApplicationStatus::GetIdentifier(void) const
{
	return mIdentifier;
}

//--------------------------------------------------------------------------------------------------------------------//

void tbApplication::ApplicationStatus::ClearStatus(void)
{
	//mStatusItems.clear();
	tbImplementation::StatusTable::iterator statusItr = tbImplementation::tbiStatusTable.find(mIdentifier);
	tb_error_if(statusItr == tbImplementation::tbiStatusTable.end(), "+tbInternalError: No status item exists for statusIdentifier(%d)", mIdentifier);
	statusItr->second.clear();
}

//--------------------------------------------------------------------------------------------------------------------//

void tbApplication::ApplicationStatus::AddStatusItem(const tbApplication::StatusItemIdentifier& itemIdentifier,
	const tbCore::tbString& statusMessage, const char partitionPlacement)
{
	tbImplementation::StatusTable::iterator statusItr = tbImplementation::tbiStatusTable.find(mIdentifier);
	tb_error_if(statusItr == tbImplementation::tbiStatusTable.end(), "+tbInternalError: No status item exists for statusIdentifier(%d)", mIdentifier);
	tbImplementation::StatusItemTable& itemTable(statusItr->second);

	tbImplementation::StatusItemTable::iterator statusItemItr = itemTable.find(itemIdentifier);
	tb_error_if(statusItemItr != itemTable.end(), "tbExternalError: StatusItem %d has already been added, use SetStatusItem to change.");
	tb_error_if(partitionPlacement < 0, "tbExternalError: Invalid value for parameter: partitionPlacement.  See documentation.");
	tb_error_if(partitionPlacement >= 100, "tbExternalError: Invalid value for parameter: partitionPlacement.  See documentation.");
	tb_error_if(itemTable.size() >= kMaximumStatusItems, "tbExternalError: Too many status items have been added to the status menu.");

	tbImplementation::StatusItemTable::value_type::second_type itemInformation(statusMessage, partitionPlacement);
	statusItr->second.insert(tbImplementation::StatusItemTable::value_type(itemIdentifier, itemInformation));
}

//--------------------------------------------------------------------------------------------------------------------//

void tbApplication::ApplicationStatus::SetStatusItem(const tbApplication::StatusItemIdentifier& itemIdentifier,
	const tbCore::tbString& statusMessage)
{
	tbImplementation::StatusTable::iterator statusItr = tbImplementation::tbiStatusTable.find(mIdentifier);
	tb_error_if(statusItr == tbImplementation::tbiStatusTable.end(), "+tbInternalError: No status item exists for statusIdentifier(%d)", mIdentifier);
	tbImplementation::StatusItemTable& itemTable(statusItr->second);

	tbImplementation::StatusItemTable::iterator statusItemItr = itemTable.find(itemIdentifier);
	tb_error_if(statusItemItr == itemTable.end(), "Unexpected: StatusItem %d has not been added, use AddStatusItem to add before changing.");

	statusItemItr->second.first = statusMessage;
}

//--------------------------------------------------------------------------------------------------------------------//

void tbImplementation::GetStatusItems(const tbApplication::StatusIdentifier& statusIdentifier, std::vector<StatusItem>& items)
{
	const tbImplementation::StatusTable::iterator statusItr = tbImplementation::tbiStatusTable.find(statusIdentifier);
	tb_error_if(statusItr == tbImplementation::tbiStatusTable.end(), "+tbInternalError: No status item exists for statusIdentifier(%d)", statusIdentifier);
	const tbImplementation::StatusItemTable& itemTable(statusItr->second);

	items.clear();
	items.reserve(itemTable.size());

	for (StatusItemTable::const_iterator itr = itemTable.begin(), itrEnd = itemTable.end(); itr != itrEnd; ++itr)
	{
		items.push_back(itr->second);
	}

	//TODO: TIM: Sort items based on partitionPosition (left edge) before returning.  Though this is working on Windows as is.
}

//--------------------------------------------------------------------------------------------------------------------//
