///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrainsImplementation_AudioPlayer_h_
#define _TurtleBrainsImplementation_AudioPlayer_h_

#include "../../core/tb_noncopyable.h"
#include "../../core/tb_string.h"
#include "../tb_audio_manager.h"

namespace tbImplementation
{
	class AudioData;

	class AudioPlayer : public tbCore::Noncopyable
	{
	public:
		AudioPlayer(const tbAudio::AudioChannel& audioChannel);
		~AudioPlayer(void);

		void PlayAudio(const AudioData& audioData, const bool isLooping = false);

		void Stop(void);
		void StopLooping(void);
		void SetPitch(float pitch);
		void SetVolume(float volume);
		float GetVolume(void) const;

		bool Update(void);
		bool IsComplete(void) const;
		const tbAudio::AudioChannel& GetIdentifier(void) const;

	private:
		const tbAudio::AudioChannel mIdentifier;
		tbCore::uint32 mBuffer;
		tbCore::uint32 mSource;
		bool mIsLooping;
	};

}; /* namespace tbImplementation */


#endif /* _TurtleBrainsImplementation_AudioPlayer_h_ */
