///
/// @file
/// @details This is the start of the sprite manager that will eventually become the TurtleBrains sprite manager.
/// @note This is a very early version of the API, expect to make constant changes until locked in at v1.0.0.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrainsImplementation_Diagnostics_h_
#define _TurtleBrainsImplementation_Diagnostics_h_

#include "../tb_configuration.h"

#if defined(tb_enable_diagnostics)
  #if !defined(tb_diagnose_errors)
    #define tb_diagnose_errors true
  #endif
  #if !defined(tb_diagnose_warnings)
    #define tb_diagnose_warnings true
  #endif
  #if !defined(tb_diagnose_information)
    #define tb_diagnose_information true
  #endif
  #if !defined(tb_diagnose_debugging)
    #define tb_diagnose_debugging false
  #endif
	#if !defined(tb_diagnose_opengl)
		#define tb_diagnose_opengl false
	#endif
#else
  #if !defined(tb_diagnose_errors)
    #define tb_diagnose_errors false
  #endif
  #if !defined(tb_diagnose_warnings)
    #define tb_diagnose_warnings false
  #endif
  #if !defined(tb_diagnose_information)
    #define tb_diagnose_information false
  #endif
  #if !defined(tb_diagnose_debugging)
    #define tb_diagnose_debugging false
  #endif
	#if !defined(tb_diagnose_opengl)
		#defined tb_diagnose_opengl false
	#endif
#endif

#if defined(tb_enable_diagnostics)
	#if !defined(tb_diagnostic_console)
		#ifdef tb_debug_build
			#define tb_diagnostic_console true
		#else
			#define tb_diagnostic_console false
		#endif
	#endif

	#if !defined(tb_diagnostic_log_path)
		#define tb_diagnostic_log_path "debug_log.txt"
	#endif

	#include "../../debug_tool_set/tb_debug_logger.h"

	#define tbi_log_error(message, ...) TurtleBrains::Debug::LogIf(tb_diagnose_errors, message, ##__VA_ARGS__);
	#define tbi_log_warning(message, ...) TurtleBrains::Debug::LogIf(tb_diagnose_warnings, message, ##__VA_ARGS__);
	#define tbi_log_info(message, ...) TurtleBrains::Debug::LogIf(tb_diagnose_information, message, ##__VA_ARGS__);
	#define tbi_log_debug(message, ...) TurtleBrains::Debug::LogIf(tb_diagnose_debug, message, ##__VA_ARGS__);
	#define tbi_log_opengl(message, ...) TurtleBrains::Debug::LogIf(tb_diagnose_opengl, message, ##__VA_ARGS__);

	#define tbi_log(message, ...) TurtleBrains::Debug::Log(message, ##__VA_ARGS__);

	#define tbi_log_open() TurtleBrains::Debug::OpenLog(tb_diagnostic_log_path, tb_diagnostic_console);
	#define tbi_log_flush() TurtleBrains::Debug::SaveLog();
	#define tbi_log_close() TurtleBrains::Debug::CloseLog();
#else
	#define tbi_log_error(message, ...) ;
	#define tbi_log_warning(message, ...) ;
	#define tbi_log_info(message, ...) ;
	#define tbi_log_debug(message, ...) ;
	#define tbi_log_opengl(message, ...) ;

	#define tbi_log(message, ...) ;

	#define tbi_log_open() ;
	#define tbi_log_flush() ;
	#define tbi_log_close() ;
#endif

#endif /* _TurtleBrainsImplementation_Diagnostics_h_ */
