///
/// @file
/// @details Provides some common definitions / macros for TurtleBrains.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrains_Defines_h_
#define _TurtleBrains_Defines_h_

///
/// @defgroup Defines General Purpose Macros
/// @{
///

///
/// @details This macro is use internally in TurtleBrains to eliminate warnings due to unused parameters.
///
#define tb_unused(parameter)	((void)parameter);

///
/// @details This macro checks the objectPointer and deletes it setting it to nullptr, this will only work for objects
///   that were dynamically allocated using new.
///
#define tb_safe_delete(objectPointer)  if (nullptr != objectPointer) { delete objectPointer; objectPointer = nullptr; }

///
/// @details This macro checks the objectPointer and deletes it setting it to nullptr, this will only work for object
///   arrays that were dynamically allocated using new [].
///
#define tb_safe_array_delete(arrayPointer) if (nullptr != arrayPointer) { delete [] arrayPointer; arrayPointer = nullptr; }

///
/// @}
///

#endif /* _TurtleBrains_Defines_h_ */
