///
/// @file
/// @details Provides an interface to take a string of json text and convert it into a DynamicStructure.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrains_JsonParser_h_
#define _TurtleBrains_JsonParser_h_

#include "../core/tb_string.h"
#include "../core/tb_dynamic_structure.h"

namespace TurtleBrains
{
	namespace Core
	{

		///
		/// TODO: TIM: This may become an "Extensions" or such that takes json to create a DynamicStructure.
		/// @details Parses a string with the "SuperEasyJSON" parser written by Jeff Weinstein and then converted into
		///   a DynamicStructure.  This is not the most memory efficient way to parse json, but most tables will likely 
		///   be loaded then destroyed after processing so the memory footprint should be temporary.  Will return a
		///   DynamicStructure of type Nil if any errors occurred such as invalid json data.
		///
		DynamicStructure ParseJson(const tbCore::tbString& jsonData);

		///
		/// TODO: TIM: This may become an "Extensions" or such that takes json to create a DynamicStructure.		
		/// @details Loads all the contents of the file specified by filepath into a string object and passes it into
		///   ParseJson returning the resulting DynamicStructure.  If the file was not loaded or memory for the string
		///   could not be allocated an error condition will be triggered.
		///
		DynamicStructure LoadJsonFile(const tbCore::tbString& filepath);

		///
		/// TODO: TIM: This belongs in some form of Utilities / FileSystem thing?
		/// @details Returns the directory path to the given file without the filename, "data/art/castle.png" would become
		///   "data/art/" on return.
		///
		tbCore::tbString GetPathFromFilepath(const tbCore::tbString& filepath);

		///
		/// TODO: TIM: This belongs in some form of Utilities / FileSystem thing?
		/// @details Attempts to find the location of a file based on a parent file for containing filepaths within another
		///   file.  Ex. A level file format containing textures, sounds or other assets.  The texture/sound or other asset
		///   would be the child file, and the level being the parent file.  This will first check if the childFilename is
		///   already existing as is, as a file and if it does, returns that path.  If it doesn't the parentFilename will be
		///   broken down to a directory path (where the level file exists) and the childFilename appended to create a
		///   second attempt to see if that file exists, returning the path if it did.  If both fail, an empty string is
		///   returned.
		///
		/// @param parentFilename The path and filename of the parent file that contains the child file, the Level file as
		///   described in the example above.
		/// @param childFilename The path to or filename of the child file that was contained in the parent file, the Asset
		///   file as described in the example above.
		///
		tbCore::tbString GetChildFilepath(const tbCore::tbString& parentFilename, const tbCore::tbString& childFilename);

	}; /* namespace Core */
}; /* namespace TurtleBrains */

namespace tbCore = TurtleBrains::Core;

#endif /* _TurtleBrains_JsonParser_h_ */
