///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrains_Noncopyable_h_
#define _TurtleBrains_Noncopyable_h_

namespace TurtleBrains
{
	namespace Core
	{

		///
		/// @details When making an object that should not be copied or assigned to another object simply deriving from
		///   Noncopyable will do the trick.  This guarentees that MyObject object(otherObject); and object = otherObject
		///   will cause a compilation error, preventing copy and/or assignment.
		///
		class Noncopyable
		{
		public:
			Noncopyable(void) { }
			~Noncopyable(void) { }

		private:
			///
			Noncopyable(const Noncopyable& other);
			Noncopyable& operator=(const Noncopyable& other);
		};

	}; /* namespace Core */
}; /* namespace TurtleBrains */

namespace tbCore = TurtleBrains::Core;

#endif /* _TurtleBrains_Noncopyable_h_ */
