///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrains_Types_h_
#define _TurtleBrains_Types_h_

#include "tb_configuration.h"
#include "tb_string.h"

#include <stdint.h>

namespace TurtleBrains
{
	namespace Core
	{
		
		typedef int8_t int8;     ///< Signed integer with a size of 8 bits. Supports values from -128 to 127
		typedef uint8_t uint8;   ///< Unsigned integer with a size of 8 bits. Supports values from 0 to 255.
		typedef int16_t int16;   ///< Signed integer with a size of 16 bits. Supports values from -32768 to 32767
		typedef uint16_t uint16; ///< Unsigned integer with a size of 16 bits. Supports values from 0 to 65535.
		typedef int32_t int32;   ///< Signed integer with a size of 32 bits. Supports values from -2147483648 to 2147483647.
		typedef uint32_t uint32; ///< Unsigned integer with a size of 32 bits. Supports values from 0 to 4294967295, (2^32 - 1).
		typedef int64_t int64;   ///< Signed integer with a size of 64 bits. Supports values from -(2^63) to (2^63 - 1).
		typedef uint64_t uint64; ///< Unsigned integer with a size of 64 bits, Supports values from 0 to (2^64 - 1).

	}; /* namespace Core */
}; /* namespace TurtleBrains */

namespace tbCore = TurtleBrains::Core;

#endif /* _TurtleBrains_Types_h_ */
