///
/// @file 
/// @details Check the version number of the TurtleBrains framework at runtime, which can be useful with dynamic
///   libraries and checking that the version is as expected.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#include "tb_version.h"
#include <sstream>

namespace tbImplementation
{

	const static int tbiVersionMajor(0);
	const static int tbiVersionMinor(2);
	const static int tbiVersionRevision(1);
	static tbCore::tbString tbiVersionString(tb_string(""));

};	/* namespace tbImplementation */

//--------------------------------------------------------------------------------------------------------------------//

int tbCore::Version::GetMajor(void)
{
	return tbImplementation::tbiVersionMajor;
}

//--------------------------------------------------------------------------------------------------------------------//

int tbCore::Version::GetMinor(void)
{
	return tbImplementation::tbiVersionMinor;
}

//--------------------------------------------------------------------------------------------------------------------//

int tbCore::Version::GetRevision(void)
{
	return tbImplementation::tbiVersionRevision;
}

//--------------------------------------------------------------------------------------------------------------------//

const tbCore::tbString& tbCore::Version::GetVersionString(void)
{
	if (true == tbImplementation::tbiVersionString.empty())
	{
		const tbString frameworkName(ToString("TurtleBrains v"));
		const tbString separatorString(ToString("."));

		tbImplementation::tbiVersionString = frameworkName + ToString(GetMajor()) + separatorString +
			ToString(GetMinor()) + separatorString + ToString(GetRevision());
	}

	return tbImplementation::tbiVersionString;
}

//--------------------------------------------------------------------------------------------------------------------//

bool tbCore::Version::IsExactly(const int major, const int minor, const int revision)
{
	return (GetMajor() == major && GetMinor() == minor && GetRevision() == revision) ? true : false;
}

//--------------------------------------------------------------------------------------------------------------------//

bool tbCore::Version::IsAtLeast(const int major, const int minor, const int revision)
{
	if (GetMajor() > major) { return true; }
	else if (GetMajor() < major) { return false; }
	//GetMajor == major
	else if (GetMinor() > minor) { return true; }
	else if (GetMinor() < minor) { return false; }
	//GetMinor == minor
	else if (GetRevision() >= revision) { return true; }
	else if (GetRevision() < revision) { return false; }
	
	//Should never hit this line, GetRevision() == revision already handled.
	return false;
}

//--------------------------------------------------------------------------------------------------------------------//
