
#ifdef tb_generate_documentation_unstable
#error This file should not be included in any project. It is for generating TurtleBrains documentation using Doxygen.

//-------------------------------------------------------------------------------------------------------------------//
/// [exampleApplicationHandlerHeader]

#include "turtle_brains/tb_application_kit.h"

class MyApplicationHandler : public tbApplication::ApplicationHandlerInterface
{
public:
	MyApplicationHandler(void);
	virtual ~MyApplicationHandler(void);
	
	virtual void OnWindowOpen(void);
	virtual void OnRealtimeUpdate(void);
	virtual void OnMenuAction(const MenuIdentifier& menu, const MenuItemIdentifier& menuItem);
	virtual void OnDialogAction(const DialogIdentifier& dialog, const DialogControlIdentifier& dialogControl);	
};

/// [exampleApplicationHandlerHeader]
//-------------------------------------------------------------------------------------------------------------------//
/// [exampleApplicationHandlerSource]

#include "my_application_handler.h"

MyApplicationHandler::MyApplicationHandler(void)
{
}

MyApplicationHandler::~MyApplicationHandler(void)
{
}

void MyApplicationHandler::OnWindowOpen(void)
{
	//Perform initialization and handle the window open event.
}

void MyApplicationHandler::OnRealtimeUpdate(void)
{
	//Perform the update of a single frame in the Realtime Application, render a frame using OpenGL.
	glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
}

void MyApplicationHandler::OnMenuAction(const MenuIdentifier& menu, const MenuItemIdentifier& menuItem)
{
	//Perform any actions when the user interacts with a particular menu / menuItem.
}

void MyApplicationHandler::OnDialogAction(const DialogIdentifier& dialog, const DialogControlIdentifier& dialogControl)
{
	//Perform any actions when the user interacts with a particular dialog / dialogControl.
}

/// [exampleApplicationHandlerSource]
//-------------------------------------------------------------------------------------------------------------------//
/// [exampleApplicationMainSource]

#include "my_application_handler.h"

void main(int argumentCount, char* argumentValues[])
{
	MyApplicationHandler myHandler;
	tbApplication::RealtimeApplication theApplication(myHandler);
	theApplication.Open();
	//The code path will remain busy until the application is closed.
	return 0;
}

/// [exampleApplicationMainSource]
//-------------------------------------------------------------------------------------------------------------------//
/// [exampleApplicationMenuValuesHeader]

enum MyMenus { kWindowMenu, kContextMenu, }
enum MyMenuItems { kMenuItemFile, kMenuItemFileCreate, kMenuItemFileExit, kMenuItemAbout, }

/// [exampleApplicationMenuValuesHeader]
//-------------------------------------------------------------------------------------------------------------------//
/// [exampleApplicationMenuCreateSource]

void MyApplicationHandler::OnWindowOpen(void)
{
	//Create a menu and set it as the Window Menu.
	tbApplication::ApplicationMenu windowMenu(kWindowMenu);
	windowMenu.AddMenuItem(kMenuItemFile, tb_string("File"));
	windowMenu.AddMenuItem(kMenuItemFileCreate, tb_string("Create"), kMenuItemFile);
	windowMenu.AddMenuItem(kMenuItemFileExit, tb_string("Exit"), kMenuItemFile);
	windowMenu.AddMenuItem(kMenuItemAbout, tb_string("About"));
	theApplication.SetWindowMenu(windowMenu);
}

/// [exampleApplicationMenuCreateSource]
//-------------------------------------------------------------------------------------------------------------------//
/// [exampleApplicationMenuHandlerSource]

void MyApplicationHandler::OnMenuAction(const MenuIdentifier& menu, const MenuItemIdentifier& menuItem)
{
	if (kWindowMenu == menu)
	{
		if (kMenuItemFileCreate == menuItem)
		{
		}
		else if (kMenuItemFileExit == menuItem)
		{
			theApplication.Close();
		}
		else if (kMenuItemAbout == menuItem)
		{
		}
	}
}

/// [exampleApplicationMenuHandlerSource]
//-------------------------------------------------------------------------------------------------------------------//
/// [exampleApplicationDialogValuesHeader]

enum MyDialogs { kDialogCreate, }
enum MyDialogControls { kControlStatic, kControlOkayButton, }

/// [exampleApplicationDialogValuesHeader]
//-------------------------------------------------------------------------------------------------------------------//
/// [exampleApplicationDialogCreateSource]

void MyApplicationHandler::OnWindowOpen(void)
{
	//Set the kStaticLabel control identifier as safe for duplication so it can be reused.
	tbApplication::ApplicationDialog::SetControlSafeForDuplication(kControlStatic);

	//Create a dialog prompt and customize it.
	tbApplication::ApplicationDialog createPrompt(kDialogCreate);
	//TODO: TIM: More dialog example...
}

/// [exampleApplicationDialogCreateSource]
//-------------------------------------------------------------------------------------------------------------------//
/// [exampleApplicationDialogHandlerSource]

void MyApplicationHandler::OnDialogAction(const DialogIdentifier& dialog, const DialogControlIdentifier& dialogControl)
{
	if (kDialogCreate == dialog)
	{
		tbApplicationDialog createPrompt(kDialogCreate);
		if (kControlOkayButton == dialogControl)
		{
			//TODO: TIM: More dialog example...
		}
	}
}

/// [exampleApplicationDialogHandlerSource]
//-------------------------------------------------------------------------------------------------------------------//
/// [exampleApplicationStatusValuesHeader]

enum MyStatusBars { kMyStatusBar, }
enum MyStatusItems { kStatusName, kStatusAge, kStatusHeight }

/// [exampleApplicationStatusValuesHeader]
//-------------------------------------------------------------------------------------------------------------------//
/// [exampleApplicationStatusCreateSource]

void MyApplicationHandler::OnWindowOpen(void)
{
	tbApplication::ApplicationStatus statusBar(kMyStatusBar);
	statusBar.AddStatusItem(kStatusName, tb_string("Current Name: Unknown"), 0);
	statusBar.AddStatusItem(kStatusAge, tb_string("Current Age: 42"), 50);
	statusBar.AddStatusItem(kStatusHeight, tb_string("Height: 5ft"), 75);
	theApplication.SetWindowStatus(statusBar);
}

/// [exampleApplicationStatusCreateSource]
//-------------------------------------------------------------------------------------------------------------------//
/// [exampleApplicationStatusHandlerSource]

void MyApplicationHandler::OnMenuAction(const MenuIdentifier& menu, const MenuItemIdentifier& menuItem)
{
	//Whenever the status, or a status item changes, the following will update the status bar.
	tbApplication::ApplicationStatus statusBar(kMyStatusBar);
	statusBar.SetStatusItem(kStatusAge, tb_string("Old Age: 100"));
	statusBar.SetStatusItem(kStatusHeight, tb_string("Height: 4ft"));
	theApplication.SetWindowStatus(statusBar);
}

/// [exampleApplicationStatusHandlerSource]

//-------------------------------------------------------------------------------------------------------------------//

#endif /* tb_generate_documentation */
