
#ifdef tb_generate_documentation
#error This file should not be included in any project. It is for generating TurtleBrains documentation using Doxygen.

//-------------------------------------------------------------------------------------------------------------------//
/// [exampleBasicGameSceneHeader]

#ifndef _Example_MyGameScene_h_
#define _Example_MyGameScene_h_

#include "turtle_brains/tb_game_kit.h"

class MyGameScene : public tbGame::GameScene
{
public:
	MyGameScene(void);
	virtual ~MyGameScene(void);

protected:
	virtual void OnSimulate(void) override;
	virtual void OnUpdate(const float deltaTime) override;
	virtual void OnRender(void) const override;
	virtual void OnOpen(void) override;
	virtual void OnClose(void) override;

private:
};

#endif _Example_MyGameScene_h_

/// [exampleBasicGameSceneHeader]
//-------------------------------------------------------------------------------------------------------------------//
/// [exampleBasicGameSceneSource]

#include "my_game_scene.h"
#include "turtle_brains/tb_application_kit.h"

MyGameScene::MyGameScene(void)
{
}

MyGameScene::~MyGameScene(void)
{
}

void MyGameScene::OnSimulate(void)
{
	tbGame::GameScene::OnSimulate();
}

void MyGameScene::OnUpdate(const float deltaTime)
{
	tbGame::GameScene::OnUpdate(deltaTime);

	if (true == tbApplication::Input::IsKeyPressed(tbApplication::tbKeyEscape))
	{
		tbGame::GameApplication::MarkForClose();
	}
}

void MyGameScene::OnRender(void) const
{
	tbGame::GameScene::OnRender();
}

void MyGameScene::OnOpen(void)
{
	tbGame::OnOpen();
}

void MyGameScene::OnClose(void)
{
	tbGame::OnClose();
}

/// [exampleBasicGameSceneSource]
//-------------------------------------------------------------------------------------------------------------------//
/// [exampleBasicGameMainSource]

#include "my_game_scene.h"

int main(int argumentCount, const char* argumentValues[])
{
	tbGame::GameApplication gameApplication;
	gameApplication.SetWindowTitle(tb_string("A TurtleBrains Game"));

	MyGameScene myScene;
	gameApplication.RunGame(myScene);

	return 0;
}

/// [exampleBasicGameMainSource]
//-------------------------------------------------------------------------------------------------------------------//

#endif /* tb_generate_documentation */
