///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved --> 
///------------------------------------------------------------------------------------------------------------------///

#include "tbi_tile_system_renderer.h"

//--------------------------------------------------------------------------------------------------------------------//

tbImplementation::TileSystemRenderer::TileSystemRenderer(void) :
	mIsDirty(true)
{
}

//--------------------------------------------------------------------------------------------------------------------//

tbImplementation::TileSystemRenderer::~TileSystemRenderer(void)
{
	Clear();
}

//--------------------------------------------------------------------------------------------------------------------//

void tbImplementation::TileSystemRenderer::Clear(void)
{
	mVertexTextureTable.clear();
}

//--------------------------------------------------------------------------------------------------------------------//

void tbImplementation::TileSystemRenderer::AddQuad(const tbGraphics::SpriteFrame& spriteFrame, const tbMath::Vector2& topLeft)
{
	const tbMath::Vector2 frameSize(static_cast<float>(spriteFrame.GetPixelWidth()), static_cast<float>(spriteFrame.GetPixelHeight()));
	AddQuad(spriteFrame, topLeft, topLeft + frameSize);
}

//--------------------------------------------------------------------------------------------------------------------//

void tbImplementation::TileSystemRenderer::AddQuad(const tbGraphics::SpriteFrame& spriteFrame,
																									 const tbMath::Vector2& topLeft, const tbMath::Vector2& bottomRight)
{
	const tbCore::uint32 white(0xFFFFFFFF);

	Renderer::Vertex2D vertices[] =
	{
		{ topLeft.x, bottomRight.y,      white,   spriteFrame.GetTexelLeft(), spriteFrame.GetTexelBottom(),    },
		{ topLeft.x, topLeft.y,          white,   spriteFrame.GetTexelLeft(), spriteFrame.GetTexelTop(),    },
		{ bottomRight.x, bottomRight.y,  white,   spriteFrame.GetTexelRight(), spriteFrame.GetTexelBottom(),    },
		{ bottomRight.x, topLeft.y,      white,   spriteFrame.GetTexelRight(), spriteFrame.GetTexelTop(),    },
	};

	mVertexTextureTable[spriteFrame.mTexture].push_back(vertices[0]);
	mVertexTextureTable[spriteFrame.mTexture].push_back(vertices[1]);
	mVertexTextureTable[spriteFrame.mTexture].push_back(vertices[2]);

	mVertexTextureTable[spriteFrame.mTexture].push_back(vertices[1]);
	mVertexTextureTable[spriteFrame.mTexture].push_back(vertices[3]);
	mVertexTextureTable[spriteFrame.mTexture].push_back(vertices[2]);
}

//--------------------------------------------------------------------------------------------------------------------//

void tbImplementation::TileSystemRenderer::Render(void) const
{
	for (VertexByTextureTable::const_iterator itr = mVertexTextureTable.begin(), itrEnd = mVertexTextureTable.end(); itr != itrEnd; ++itr)
	{
		tbGraphics::theTextureManager.BindTexture(itr->first);
		Renderer::Render(Renderer::kTriangles, itr->second.data(), itr->second.size());
	}
}

//--------------------------------------------------------------------------------------------------------------------//
