///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved --> 
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrainsImplementation_TileSystemRenderer_h_
#define _TurtleBrainsImplementation_TileSystemRenderer_h_

#include "../../core/tb_noncopyable.h"
#include "../../graphics/tb_sprite.h"
#include "../../graphics/implementation/tbi_renderer.h"
#include "../../math/tb_vector.h"

#include <vector>
#include <map>

namespace tbImplementation
{

	class TileSystemRenderer : public tbCore::Noncopyable
	{
	public:
		TileSystemRenderer(void);
		virtual ~TileSystemRenderer(void);

		void Clear(void);
		void AddQuad(const tbGraphics::SpriteFrame& spriteFrame, const tbMath::Vector2& topLeft);
		void AddQuad(const tbGraphics::SpriteFrame& spriteFrame, const tbMath::Vector2& topLeft, const tbMath::Vector2& bottomRight);
		void Render(void) const;

	private:
		bool mIsDirty;

		typedef std::vector<tbImplementation::Renderer::Vertex2D> VertexContainer;
		typedef std::map<tbGraphics::TextureHandle, VertexContainer> VertexByTextureTable;
		VertexByTextureTable mVertexTextureTable;
	};

};	/* namespace tbImplementation */

#endif /* _TurtleBrainsImplementation_TileSystemRenderer_h_ */
