///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved --> 
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrains_EntityManager_h_
#define _TurtleBrains_EntityManager_h_

#include "tb_entity.h" //For EntityType definition.
#include "../core/tb_noncopyable.h"

#include <map>
#include <set>
#include <list>

namespace TurtleBrains
{
	namespace Game
	{

		class Entity;

		///
		/// TODO: TIM: Documentation: Teach the user how to use this.
		/// @note this is not yet useful.
		///
		class EntityFactoryInterface : public tbCore::Noncopyable
		{
		public:
			///
			/// TODO: TIM: Documentation: Teach the user how to use this.
			///
			EntityFactoryInterface(void);

			///
			/// TODO: TIM: Documentation: Teach the user how to use this.
			///
			virtual ~EntityFactoryInterface(void);

			///
			/// TODO: TIM: Documentation: Teach the user how to use this.
			///
			Entity* CreateEntityByType(const EntityType& entityType);

			///
			/// TODO: TIM: Documentation: Teach the user how to use this.
			///
			bool DestroyEntity(Entity* entityToDestroy);
		};

////The following is what I want to do and not what currently happens.  Currently Scene will have more code to handle
////the AwesomeItem() being created and cleaned up properly, but I would like to reduce this burden on myself and
////other developers using TurtleBrains by having the Manager become the owner of the item.  BUT I also -really- want
////the ability to have a member variable like mCoin that is owned by the Scene and created/destroyed with the scene.
////Obviously this item can NOT be deleted.
//
// UPDATE (before) March 22, 2016:
//
// The following is now working with GraphicList and EntityManager by using two similar, but DIFFERENT, AddItem()
//   functions:  AddItem(ItemInterface* managedItem) will get deleted automatically, add and forget, while the alternative
//   AddItem(ItemInterface& ownedItem) will not be deleted or cleaned up, and is expected to remain in scope/valid until
//   after it gets manually removed.
//
////Simple abstract class that developer than derives from.
//class ItemInterface
//{
//public:
//	virtual ~ItemInterface(void) = 0;
//};
//
////Manager for the class, be it Entities, Graphics etc...
//class Manager
//{
//public:
//	void AddItem(ItemInterface* item);
//	void RemoveItem(ItemInterface* item);
//
//	//Contain and do things with Items...
//};
//
////Usage example of sorts
//class Scene
//{
//public:
//	void OnEnter()
//	{
//		//The following line is desired, but currently can't be done because Scene needs to own (cleanup) the item.
//		//But I want to support dynamically allocated items for bullets and other effects/entities etc... that then
//		//clean themselves up automatically when theManager.RemoveItem() is called on it, without needing Scene() to
//		//do so.
//		theManager.AddItem(new AwesomeItem());
//
//		//The following is okay and works flawlessly without dynamic memory!
//		theManager.AddItem(&mCoin);
//	}
//
//	void OnExit()
//	{
//
//		theManager.RemoveItem(&mCoin);
//		theManager.ClearItems();
//	}
//
//private:
//	CoinItem mCoin;
//};







		///
		///	@details The EntityManager is a container of entities to perform Simulate, Update and Render on, as well as
		///   collisions and provides access to the entities by type or intersected areas. Entities added by AddEntity(Entity*)
		///   will be deleted when the entity is removed or EntityManager is destroyed while entities added by AddEntity(Entity&)
		///   are expected to remain available and in scope until removed.
		///
		class EntityManager : public tbGraphics::GraphicList
		{
		public:
			///
			/// @details A simple list of entities.
			///
			typedef std::list<Entity*> EntityList;

			///
			///	@details Constructs an empty entity object which contains no Graphics and position is defaults to 0,0.
			///
			EntityManager(void);

			///
			///	@details Destructs an entity which currently (TurtleBrains v0.2.0) does not have any resources to clean
			///   up after.
			///
			virtual ~EntityManager(void) = 0;

			///
			/// @details First creates an Entity by calling the EntityFactoryInterface CreateEntity() then adds the entity to
			///   be managed and accessed.
			///
			/// @note This function currently is not implemented, undecided how the EntityFactoryInterface will register.
			///
//			Entity& AddEntity(const EntityType& entityType);

			///
			/// @details Adds an Entity to the manager in a few containers for the entity to be accessed, and it will be
			///   simulated, updated and rendered each frame while it exists in the EntityManager. When the Entity
			///   is removed from the manager it will be deleted, cleaned up and destroyed.
			///
			void AddEntity(Entity* entity);

			///
			/// @details Adds an Entity to the manager in a few containers for the entity to be accessed, and it will be
			///   simulated, updated and rendered each frame while it exists in the EntityManager. When the Entity
			///   is removed from the manager it will NOT be deleted or cleaned up, or destroyed. The EntityManager will not
			///   'own' an entity added this way.
			///
			void AddEntity(Entity& entity);

			///
			/// @details Marks an Entity for removal from the EntityManger, the actual removal will happen at the end of either
			///   Simulate or Update to prevent modifying the container while iterating through it.
			///
			void RemoveEntity(Entity* entity);

			///
			/// @details Marks entities for removal by type, or removes all entities if Entity::kInvalidType is used.
			///
			void RemoveEntities(const EntityType& byType = Entity::kInvalidType);

			///
			/// @details Removes the Entity from the EntityType containers and reupdates based on the new EntityTypes.
			///
			void EntityTypeChanged(Entity& entity, const EntityTypeContainer& oldTypes);

			///
			/// @details Creates an EntityList containing all the entities and returns it for general use.
			///
			EntityList GetAllEntities(void);

			///
			/// @details Creates an EntityList containing all the entities that have the EntityType byType.
			///
			EntityList GetEntitiesByType(const EntityType& byType);

			///
			/// TODO: TIM: Documentation: Teach the user how to use this.
			///
			/// @note This will only get entities that the point collides with one of the bounding volumes, and requires the
			///   entity to have a bounding volume to work correctl.y
			///
			EntityList GetEntitiesAt(const tbMath::Vector2& point, const EntityType& byType = Entity::kInvalidType, bool onlyCollidableEntities = false);

			///
			///	@details TODO: TIM: Documentation: Teach the user how to use this.
			///
			EntityList GetEntitiesWithin(const tbMath::Vector2& center, const float radius, const EntityType& byType = Entity::kInvalidType, bool onlyCollidableEntities = false);

			///
			///	@details TODO: TIM: Documentation: Teach the user how to use this.
			///
			EntityList GetEntitiesWithin(const tbMath::Vector2& center, const float width, const float height, const EntityType& byType = Entity::kInvalidType, bool onlyCollidableEntities = false);

			///
			///	@details Calls Simulate() on each of the entities, and then calls PerformCollision() to check for collision
			///   updates before finally removing any entities that may have expired during the simulate logic.
			///
			void Simulate(void);

		protected:
			///
			///	@details Calls Update() on each of the entities, before removing any entities that may have expired.
			///
			virtual void OnUpdate(const float deltaTime) override;

		private:
			void ReallyAddEntity(Entity* entity, bool managed);
			void SafeToRemoveEntities(void);

			typedef std::set<Entity*> EntitySet;
			typedef std::map<EntityType, EntityList> EntityByTypeMap;

			EntityList mEntities;
			EntityList mManagedEntities;
			EntitySet mEntitiesToRemove;
			EntityByTypeMap mEntitiesByType;
		};

	}; /* namespace Game */
}; /* namespace TurtleBrains */

namespace tbGame = TurtleBrains::Game;

#endif /* _TurtleBrains_EntityManager_h_ */
