///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved --> 
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrains_GameApplication_h_
#define _TurtleBrains_GameApplication_h_

#include "../application/tb_realtime_application.h"
#include "../graphics/tb_texture_manager.h" //For PixelSpace typedef.

namespace TurtleBrains
{
	namespace Game
	{
		class GameScene;

		///
		/// @details the GameApplication will create a basic ApplicationHandler and RealtimeApplication, and get the
		///   game state machine running.  Simply create an instance of each of your gamestates and call RunGame and let
		///   the GameApplication handle the rest.
		///
		class GameApplication : public Application::RealtimeApplication, public tbCore::Error::ErrorHandlerInterface
		{
		public:
			///
			///	@details Constructs the GameApplication object, opens the RealTime window with the size of 1280x720.
			///   An error condition will be triggered if there is already a GameApplication instance in existance or
			///   if there were any trouble opening the real time application window.  Also adds itself as an error
			///   handler that will popup a message box with the error contents.
			///
			GameApplication(const tbGraphics::PixelSpace& windowWidth = 1280, const tbGraphics::PixelSpace& windowHeight = 720, const bool verticalSync = true);

			///
			///	@details Destroys the GameApplication object and removes itself from the list of error handlers.
			///
			~GameApplication(void);

			///
			///	@details Begins running the real-time message pump for the window, starts first with the TurtleBrains
			///   introduction scene (in release builds) and then sets the provided gameScene as the active scene.
			///
			/// @param gameScene The first scene of the game to be active, usually a splash or title screen before the
			///   gameplay begins.
			///
			void RunGame(GameScene& gameScene);

			///
			/// @details Set a custom application handler to complement the default handler of the game application.  When
			///   creating a game with a built in editor it is useful to handle the Menu and Dialog actions of the
			///   application.
			///
			/// @param applicationHandler		A custom application handler to be called during certain handled events.
			///
			/// @note not all handler functions will be called on the provided application handler, currently only the
			///   OnMenuAction and OnDialogAction calls are made.
			///
			void SetApplicationHandler(Application::ApplicationHandlerInterface* applicationHandler);

			///
			/// @details Provides a way to shutdown the game, which will occur after the frame is completed.
			///
			static void MarkForClose(void);

			///
			/// @details Checks to see if the GameApplication is the currently active application that the operating system
			///   is running, meaning input and other things should be processed.
			///
			static bool IsGameActive(void);

		private:

			///
			///	@details This is an implementation detail of the TurtleBrains GameApplication which pops up a message
			///   box containing the contents of a triggered error.
			///
			virtual void OnErrorFired(const std::string& errorMessage) override;

			GameScene* mErrorScene;
		};

	}; /* namespace Game */
}; /* namespace TurtleBrains */

namespace tbGame = TurtleBrains::Game;

#endif /* _TurtleBrains_GameApplication_h_ */
