///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved --> 
///------------------------------------------------------------------------------------------------------------------///

#include "tb_game_timer.h"

tbGame::GameTimer::Milliseconds tbGame::GameTimer::sMillisecondsPerStep(10);

tbGame::GameTimer tbGame::GameTimer::kZero(static_cast<tbCore::uint32>(0));
tbGame::GameTimer tbGame::GameTimer::kInfinity(static_cast<tbCore::uint32>(-1));

//--------------------------------------------------------------------------------------------------------------------//

tbGame::GameTimer::GameTimer(void) :
	mMillisecondTimer(0)
{
}

//--------------------------------------------------------------------------------------------------------------------//

tbGame::GameTimer::GameTimer(const tbGame::GameTimer::Milliseconds& valueMilliseconds) :
	mMillisecondTimer(valueMilliseconds)
{
}

//--------------------------------------------------------------------------------------------------------------------//

tbGame::GameTimer::GameTimer(const GameTimer& other) :
	mMillisecondTimer(other.mMillisecondTimer)
{
}

//--------------------------------------------------------------------------------------------------------------------//

tbGame::GameTimer::~GameTimer(void)
{
}

//--------------------------------------------------------------------------------------------------------------------//

tbGame::GameTimer& tbGame::GameTimer::operator=(const tbGame::GameTimer& other)
{
	mMillisecondTimer = other.mMillisecondTimer;
	return *this;
}

//--------------------------------------------------------------------------------------------------------------------//

bool tbGame::GameTimer::DecrementStep(void)
{
	if (mMillisecondTimer <= sMillisecondsPerStep)
	{
		mMillisecondTimer = 0;
		return true;
	}

	mMillisecondTimer -= sMillisecondsPerStep;
	return false;
}

//--------------------------------------------------------------------------------------------------------------------//

bool tbGame::GameTimer::IncrementStep(const GameTimer& maximumValue)
{
	tb_error_if(maximumValue.mMillisecondTimer < sMillisecondsPerStep, "tbExternalError: maximumValue must be larger than MillisecondsPerStep.");

	if (maximumValue.mMillisecondTimer - sMillisecondsPerStep <= mMillisecondTimer)
	{
		mMillisecondTimer = maximumValue.mMillisecondTimer;
		return true;
	}

	mMillisecondTimer += sMillisecondsPerStep;
	return false;
}

//--------------------------------------------------------------------------------------------------------------------//

bool tbGame::GameTimer::IsZero(void) const
{
	return (0 == mMillisecondTimer) ? true : false;
}

//--------------------------------------------------------------------------------------------------------------------//

const tbGame::GameTimer::Milliseconds& tbGame::GameTimer::GetElapsedTime(void) const
{
	return mMillisecondTimer;
}

//--------------------------------------------------------------------------------------------------------------------//

const tbGame::GameTimer::Milliseconds& tbGame::GameTimer::GetRemainingTime(void) const
{
	return mMillisecondTimer;
}

//--------------------------------------------------------------------------------------------------------------------//

float tbGame::GameTimer::GetPercentageOf(const tbGame::GameTimer& timeValue) const
{
	tb_error_if(0 == timeValue.mMillisecondTimer, "tbExternalError: Expected timeValue to be a non-zero time value.");
	return static_cast<float>(mMillisecondTimer) / static_cast<float>(timeValue.mMillisecondTimer);
}

//--------------------------------------------------------------------------------------------------------------------//

float tbGame::GameTimer::ToSeconds(const tbGame::GameTimer::Milliseconds& valueMilliseconds)
{
	return valueMilliseconds / 1000.0f;
}

//--------------------------------------------------------------------------------------------------------------------//

tbGame::GameTimer::Milliseconds tbGame::GameTimer::ToMilliseconds(const float& valueSeconds)
{
	return static_cast<tbGame::GameTimer::Milliseconds>(valueSeconds * 1000.0f);
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGame::GameTimer::SetMillisecondsPerStep(const tbGame::GameTimer::Milliseconds& millisecondsPerStep)
{
	tb_error_if(millisecondsPerStep <= 0, "tbExternalError: Expected millisecondsPerStep to be greater than zero.");
	sMillisecondsPerStep = millisecondsPerStep;
}

//--------------------------------------------------------------------------------------------------------------------//

tbGame::GameTimer::Milliseconds tbGame::GameTimer::GetMillisecondsPerStep(void)
{
	tb_error_if(sMillisecondsPerStep <= 0, "tbInternalError: Expected sMillisecondsPerStep to be greater than zero.");
	return sMillisecondsPerStep;
}

//--------------------------------------------------------------------------------------------------------------------//

float tbGame::GameTimer::GetSecondsPerStep(void)
{
	tb_error_if(sMillisecondsPerStep <= 0, "tbInternalError: Expected sMillisecondsPerStep to be greater than zero.");
	return ToSeconds(sMillisecondsPerStep);
}

//--------------------------------------------------------------------------------------------------------------------//
