///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved --> 
///------------------------------------------------------------------------------------------------------------------///

#include "tbu_tile_system_collider.h"
#include "../../math/unstable/tbu_bounding_volume.h"

//--------------------------------------------------------------------------------------------------------------------//
//--------------------------------------------------------------------------------------------------------------------//

bool tbGame::Unstable::TileSystemCollider::MoveEntity(const tbMath::Vector2& currentPosition, tbMath::Vector2& finalPosition,
	const tbMath::Unstable::BoundingVolume& boundingVolume) const
{
	bool completedMovement = true;
	for (ObjectContainer::const_iterator objectItr = mStaticObjects.begin(), objectEnd = mStaticObjects.end(); objectItr != objectEnd; ++objectItr)
	{
		if (boundingVolume.CheckCollisionWith(finalPosition, objectItr->mBoundingVolume, objectItr->mCenterPosition))
		{
			boundingVolume.ResolveCollisionWithStatic(finalPosition, objectItr->mBoundingVolume, objectItr->mCenterPosition);
			completedMovement = false;
		}
	}

	return completedMovement;
}

//--------------------------------------------------------------------------------------------------------------------//

bool tbGame::Unstable::TileSystemCollider::IsPointInSolid(const tbMath::Vector2& pointPosition) const
{
	for (ObjectContainer::const_iterator objectItr = mStaticObjects.begin(), objectEnd = mStaticObjects.end(); objectItr != objectEnd; ++objectItr)
	{
		if (objectItr->mBoundingVolume.CheckCollisionWith(objectItr->mCenterPosition, pointPosition))
		{
			return true;
		}
	}

	return false;
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGame::Unstable::TileSystemCollider::ClearStaticObjects(void)
{
	mStaticObjects.clear();
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGame::Unstable::TileSystemCollider::AddStaticObject(const tbMath::Unstable::BoundingVolume& boundingVolume, const tbMath::Vector2& centerPosition)
{
	mStaticObjects.push_back(Object(boundingVolume, centerPosition));
}

//--------------------------------------------------------------------------------------------------------------------//
//--------------------------------------------------------------------------------------------------------------------//
//--------------------------------------------------------------------------------------------------------------------//

tbGame::Unstable::TileSystemCollider::Object::Object(const tbMath::Unstable::BoundingVolume& boundingVolume, const tbMath::Vector2& centerPosition) :
	mBoundingVolume(boundingVolume),
	mCenterPosition(centerPosition)
{
}

//--------------------------------------------------------------------------------------------------------------------//
