///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrainsUnstable_TileSystemCollider_h_
#define _TurtleBrainsUnstable_TileSystemCollider_h_

#include "../tb_tile_system.h"
#include "../../math/unstable/tbu_bounding_volume.h"

#include <vector>

///@cond document_implementation

namespace TurtleBrains
{
	namespace Game
	{
		namespace Unstable
		{

			class TileSystemCollider
			{
			public:
				bool MoveEntity(const tbMath::Vector2& currentPosition, tbMath::Vector2& finalPosition,
					const tbMath::Unstable::BoundingVolume& boundingVolume) const;

				bool IsPointInSolid(const tbMath::Vector2& pointPosition) const;

				///
				///
				void ClearStaticObjects(void);

				///
				///
				void AddStaticObject(const tbMath::Unstable::BoundingVolume& boundingVolume, const tbMath::Vector2& centerPosition);

			private:
				struct Object
				{
					Object(const tbMath::Unstable::BoundingVolume& boundingVolume, const tbMath::Vector2& centerPosition);

					tbMath::Unstable::BoundingVolume mBoundingVolume;
					tbMath::Vector2 mCenterPosition;
				};

				typedef std::vector<Object> ObjectContainer;
				ObjectContainer mStaticObjects;
			};
			
		}; /* namespace Unstable */
	}; /* namespace Game */
}; /* namespace TurtleBrains */

///@endcond

namespace tbGame = TurtleBrains::Game;

#endif /* _TurtleBrainsUnstable_TileSystemCollider_h_ */
