///
/// @file
/// @details This is the start of the sprite manager that will eventually become the TurtleBrains sprite manager.
/// @note This is a very early version of the API, expect to make constant changes until locked in at v1.0.0.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrainsImplementation_Renderer_h_
#define _TurtleBrainsImplementation_Renderer_h_

#include "../../math/tb_vector.h"
#include "../../math/tb_matrix.h"
#include "../../core/tb_types.h"

#include "../../core/implementation/tbi_diagnostics.h"

#define tb_legacy_gl_support
//#define tb_legacy_gl_forced

#if defined(tb_debug_build)
	#define tb_check_recent_gl_errors(description) { tbImplementation::Renderer::CheckErrors(__FILE__, __LINE__, description); }
	#define tb_check_gl_errors(glFunctionCall) { tbi_log_opengl("glCall: "#glFunctionCall "\n"); glFunctionCall; tbImplementation::Renderer::CheckErrors(__FILE__, __LINE__, #glFunctionCall); }
#else
	#define tb_check_recent_gl_errors(description) ;
	#define tb_check_gl_errors(glFunctionCall) { glFunctionCall; }
#endif

namespace tbImplementation
{

	namespace Renderer
	{
		extern bool tbiIsRendererAvailable;

		enum PrimitiveType
		{
			kTriangles,
			kTriangleStrip,
			kTriangleFan,
			kLines,
			kLineStrip,
			kLineLoop,
		};

		struct Vertex2D
		{
			float x, y;
			tbCore::uint32 abgr;
			float u, v;
		};

		struct Vertex3D
		{
			float x, y, z;
			float i, j, k;
			tbCore::uint32 abgr;
			float u, v;
		};

#if defined(tb_legacy_gl_support)
		bool IsLegacyRenderer(void);
		void SetLegacyRenderer(bool isLegacy);
#endif /* tb_legacy_gl_support */

		void InitializeBasicRenderer(void);
		void CleanupBasicRenderer(void);

		void SetProjectionMatrix(const tbMath::Matrix4& projectionMatrix);
		const tbMath::Matrix4& GetProjectionMatrix(void);

		void SetModelViewMatrix(const tbMath::Matrix4& modelViewMatrix);
		const tbMath::Matrix4& GetModelViewMatrix(void);

		void SetColorMatrix(bool forText);

		//The following only work for the modelViewMatrix.
		void PushMatrix(void);
		void PopMatrix(void);
		void MultiplyMatrix(const tbMath::Matrix4& matrix);
		void Translate(float x, float y, float z);
		void Rotate(float angleInDegrees, float x, float y, float z);
		void Scale(float x, float y, float z);

		void BeginDraw(void);
		void EndDraw(void);

		void Render(const PrimitiveType& primitiveType, const Vertex2D* vertices, const size_t& vertexCount);
		void Render(const PrimitiveType& primitiveType, const Vertex3D* vertices, const size_t& vertexCount);
		void RenderSprite(const tbMath::Vector2& topLeft, const tbMath::Vector2& bottomRight, const tbCore::uint32& color);

		void ClearErrors(void);
		void CheckErrors(const char* const fromFile, int onLineNumber, const char* const message);

		bool DidShaderCompile(int glShader);
		bool DidProgramLink(int glProgram);
	};

}; /* namespace tbImplementation */

#endif /* _TurtleBrainsImplementation_Renderer_h_ */
