///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#include "tb_graphic.h"
#include "tb_camera.h"
#include "implementation/tbi_renderer.h"

//--------------------------------------------------------------------------------------------------------------------//

float tbGraphics::ScreenWidth(void)
{	//TODO: TIM: This may need to be tied to the tbApplication namespace to get the actual width of the RealtimeApplication.
	return 1280.0f;
}

//--------------------------------------------------------------------------------------------------------------------//

float tbGraphics::ScreenHeight(void)
{	//TODO: TIM: This may need to be tied to the tbApplication namespace to get the actual height of the RealtimeApplication.
	return 720.0f;
}

//--------------------------------------------------------------------------------------------------------------------//

tbMath::Vector2 tbGraphics::ScreenCenter(void)
{
	return tbMath::Vector2(ScreenWidth() / 2.0f, ScreenHeight() / 2.0f);
}

//--------------------------------------------------------------------------------------------------------------------//

tbGraphics::Graphic::Graphic(void) :
	mPosition(0.0f, 0.0f),
	mOrigin(0.0f, 0.0f),
	mScale(1.0f, 1.0f),
	mScroll(1.0f, 1.0f),
	mOrientation(0.0f),
	mDepthZ(0.0f),
	mIsActive(true),
	mIsVisible(true),
	mIsRelative(true),
	mColor(Color::kWhite)
{
}

//--------------------------------------------------------------------------------------------------------------------//

tbGraphics::Graphic::Graphic(const Graphic& other) :
	mPosition(other.mPosition),
	mOrigin(other.mOrigin),
	mScale(other.mScale),
	mScroll(other.mScroll),
	mOrientation(other.mOrientation),
	mDepthZ(other.mDepthZ),
	mIsActive(other.mIsActive),
	mIsVisible(other.mIsVisible),
	mIsRelative(other.mIsRelative),
	mColor(other.mColor)
{
}

//--------------------------------------------------------------------------------------------------------------------//

tbGraphics::Graphic::~Graphic(void)
{
}

//--------------------------------------------------------------------------------------------------------------------//

//tbGraphics::Graphic& tbGraphics::operator=(const tbGraphics::Graphic& other)
//{
//  Incomplete, letting the compiler create this as there is no dynamic memory.
//	mScale = other.mScale;
//	mOrigin = other.mOrigin;
//	mOrientation = other.mOrientation;
//}

//--------------------------------------------------------------------------------------------------------------------//

bool tbGraphics::Graphic::IsActive(void) const
{
	return mIsActive;
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::Graphic::SetActive(const bool isActive)
{
	mIsActive = isActive;
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::Graphic::Update(const float deltaTime)
{
	if (true == IsActive())
	{
		OnUpdate(deltaTime);
	}
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::Graphic::OnUpdate(const float deltaTime)
{
}

//--------------------------------------------------------------------------------------------------------------------//

bool tbGraphics::Graphic::IsVisible(void) const
{
	return mIsVisible;
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::Graphic::SetVisible(const bool isVisible)
{
	mIsVisible = isVisible;
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::Graphic::Render(void) const
{
	if (true == IsVisible())
	{
		ApplyTransform();
		OnRender();
		PopTransform();
	}
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::Graphic::OnRender(void) const
{
}

//--------------------------------------------------------------------------------------------------------------------//

const tbMath::Vector2& tbGraphics::Graphic::GetPosition(void) const
{
	return mPosition;
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::Graphic::SetPosition(const float x, const float y)
{
	SetPosition(tbMath::Vector2(x, y));
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::Graphic::SetPosition(const tbMath::Vector2 &position)
{
	mPosition = position;
}


//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::Graphic::SetOrigin(const AnchorLocation& anchor)
{
	const float graphicWidth(GetWidth());
	const float graphicHeight(GetHeight());

	switch (anchor)
	{
	default:
	case kAnchorCenter: SetOrigin(graphicWidth / 2.0f, graphicHeight / 2.0f);	break;
	case kAnchorTopLeft: SetOrigin(0.0f, 0.0f);	break;
	case kAnchorTopCenter: SetOrigin(graphicWidth / 2.0f, 0.0f);	break;
	case kAnchorTopRight: SetOrigin(graphicWidth, 0.0f);	break;
	case kAnchorCenterLeft: SetOrigin(0.0f, graphicHeight / 2.0f);	break;
	case kAnchorCenterRight: SetOrigin(graphicWidth, graphicHeight / 2.0f);	break;
	case kAnchorBottomLeft: SetOrigin(0.0f, graphicHeight);	break;
	case kAnchorBottomCenter: SetOrigin(graphicWidth / 2.0f, graphicHeight);	break;
	case kAnchorBottomRight: SetOrigin(graphicWidth, graphicHeight);	break;
	};
}

//--------------------------------------------------------------------------------------------------------------------//

float tbGraphics::Graphic::GetDepth(void) const
{
	return mDepthZ;
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::Graphic::SetDepth(const float newDepth)
{
	mDepthZ = newDepth;
}

//--------------------------------------------------------------------------------------------------------------------//

bool tbGraphics::Graphic::IsRelative(void) const
{
	return mIsRelative;
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::Graphic::SetColor(const tbGraphics::Color& newColor)
{
	mColor = newColor;
}

//--------------------------------------------------------------------------------------------------------------------//

const tbGraphics::Color& tbGraphics::Graphic::GetColor(void) const
{
	return mColor;
}

//--------------------------------------------------------------------------------------------------------------------//

//void tbGraphics::Graphic::SetRelative(const bool isRelative)
//{
//	mIsRelative = isRelative;
//}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::Graphic::ApplyTransform(void) const
{
	tbImplementation::Renderer::PushMatrix();

	//if (false == tbMath::IsEqual(1.0f, mScroll.x) || false == tbMath::IsEqual(1.0f, mScroll.y))
	//{
	//	const tbMath::Vector2& screenCenter(tbGraphics::ScreenCenter());
	//	tbImplementation::Renderer::Translate(-screenCenter.x, -screenCenter.y, 0.0f);
	//	tbImplementation::Renderer::Rotate(tbGraphics::Camera::GetCameraRotation(), 0.0f, 0.0f, 1.0f);
	//	tbImplementation::Renderer::Translate(screenCenter.x, screenCenter.y, 0.0f);
	//}

	const tbMath::Vector2 camera(tbGraphics::GetActiveCamera().GetPositionWithShake());
	const tbMath::Vector2& position(GetPosition());
	tbImplementation::Renderer::Translate(position.x - (camera.x * mScroll.x), position.y - (camera.y * mScroll.y), GetDepth());
	//tbImplementation::Renderer::Translate(position.x, position.y, GetDepth());

	tbImplementation::Renderer::Rotate(mOrientation, 0.0f, 0.0f, 1.0f);
	tbImplementation::Renderer::Translate(-(mOrigin.x * mScale.x), -(mOrigin.y * mScale.y), 0.0f);
	tbImplementation::Renderer::Scale(mScale.x, mScale.y, 1.0f);
}

//--------------------------------------------------------------------------------------------------------------------//

void tbGraphics::Graphic::PopTransform(void) const
{
	tbImplementation::Renderer::PopMatrix();
}

//--------------------------------------------------------------------------------------------------------------------//
