///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrains_Constants_h_
#define _TurtleBrains_Constants_h_

namespace TurtleBrains
{
	namespace Math
	{

		static const float kPi(3.14159265358979310f);     ///<	A constant for the mathematical concept of Pi stored in a float.
		static const float kTwoPi(kPi * 2.0f); ///<	A constant for Pi * 2 stored in a float

		///
		/// @details When comparing a float for equality or to zero, this is the default tolerance used.  When the
		///   difference is less than the tolerance, the values are considered the same.
		static const float kTolerance(0.00001f);

		//Conversions
		const float kPoundsToKilograms(0.45359237f); ///< A constant for the conversion of 1 pound (lb) to 1 kilogram (kg).
		const float kKilogramsToPounds(1.0f / kPoundsToKilograms); ///<	A constant for the conversion of 1 kilogram (kg) to 1 pound (lb).
		const float kInchesToMeters(0.0254f); ///< A constant for the distance conversion of 1 inch to 1 meter.
		const float kMetersToInches(1.0f / kInchesToMeters); ///< A constant for the distance conversion of 1 meter to 1 inch.
		const float kFeetToMeters(0.3048f); ///< A constant for the distance conversion from 1 foot to 1 meter.
		const float kMetersToFeet(1.0f / kFeetToMeters); ///< A constant for the distance conversion from 1 meter to 1 foot.
		const float kMilesToKilometers(1.609344f); ///<	A constant for the distance conversion from 1 mile to 1 kilometer.
		const float kKilometersToMiles(1.0f / kMilesToKilometers); ///< A constant for the distance conversion from 1 kilometer to 1 mile.
		const float kFootPoundsToNewtonMeters(0.73756214837f); ///< A constant for the torque in ft-lbs to Nm
		const float kNewtonMetersToFootPounds(1.0f / kFootPoundsToNewtonMeters); ///< A constant for the torque conversion from Nm to ft-lbs.

		namespace Convert
		{	//Conversion Functions...  Most of these values were found from Google.
			//Rotations

			///
			/// @details Converts an angle in degrees into an angle in radians.
			///
			inline float DegreesToRadians(const float degrees) { return degrees * kPi / 180.0f;	}

			///
			/// @details Converts an angle in radians into an angle in degrees.
			///
			inline float RadiansToDegrees(const float radians) { return radians * 180.0f / kPi;	}

			//Weights/Mass

			///
			/// @details Converts a value, weight, in pounds (lbs) to a value, mass, in kilograms (kg).
			///
			inline float PoundsToKilograms(const float pounds) { return pounds * kPoundsToKilograms; }

			///
			/// @details Converts a value, mass, in kilograms (kg) to a value, weight, in pounds (lbs).
			///
			inline float KilogramsToPounds(const float kilograms) { return kilograms * kKilogramsToPounds; }

			//Distances

			///
			/// @details Converts a value, distance, in inches to a value, distance, in meters.
			///
			inline float InchesToMeters(const float inches) { return inches * kInchesToMeters; }

			///
			/// @details Converts a value, distance, in feet to a value, distance, in meters.
			///
			inline float FeetToMeters(const float feet) { return feet * kFeetToMeters; };

			///
			/// @details Converts a value, distance, in miles (mi) to a value, distance, in kilometers (km).
			///
			inline float MilesToKilometers(const float mile) { return mile * kMilesToKilometers; }

			///
			/// @details Converts a value, distance, in kilometers (km) to a value, distance, in miles (mi).
			///
			inline float KilometersToMiles(const float kilometers) { return kilometers * kKilometersToMiles; }

			//Speeds

			///
			/// @details Converts a value, speed, in miles per hour (mph) to a value, speed, in meters per second.
			///
			inline float MileHourToMeterSecond(const float mph) { return mph / 2.2369362920544f; }

			///
			/// @details Converts a value, speed, in meters per second to a value, speed, in miles per hour.
			///
			inline float MeterSecondToMileHour(const float meterSec) { return meterSec * 2.2369362920544f; }

			///
			/// @details Converts a value, speed, in kilometer per hour (kph) to a value, speed, in meters per second.
			///
			inline float KilometerHourToMeterSecond(const float kmh) { return kmh / 3.6f; }

			///
			/// @details Converts a value, speed, in meters per second to a value, speed, in kilometers per hour (kph).
			///
			inline float MeterSecondToKilometerHour(const float meterSecond) { return meterSecond * 3.6f; }

			//Torque

			///
			/// @details Converts a value, torque, in foot-pounds (ft-lbs) to a value, torque, in Newton-meters (Nm).
			///
			inline float FootPoundsToNewtonMeters(const float footPounds) { return footPounds / kFootPoundsToNewtonMeters; }

			///
			/// @details Converts a value, torque, in Newton-meters (Nm) to a value, torque, in foot-pounds (ft-lbs).
			///
			inline float NewtonMetersToFootPounds(const float newtonMeters) { return newtonMeters / kNewtonMetersToFootPounds; }

			//Temperature

			///
			/// @details Converts a temperature value from degrees Fahrenheit to degrees Celsius.
			///
			inline float FahrenheitToCelsius(const float fahrenheit) { return (fahrenheit - 32.0f) / 1.8000f; }

			///
			/// @details Converts a temperature value from degrees Celsius to degrees Fahrenheit.
			///
			inline float CelsiusToFahrenheit(const float celsius) { return (celsius * 1.8000f) + 32.0f; }

		};	/* namespace Convert */
	}; /* namespace Math */
}; /* namespace TurtleBrains */

namespace tbMath = TurtleBrains::Math;

#endif /* _TurtleBrains_Constants_h_ */
