///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#include "tb_random_numbers.h"
#include "tb_constants.h"
#include <cstdlib>	//For the definition of RAND_MAX

//--------------------------------------------------------------------------------------------------------------------//

void tbMath::SeedRandomGenerator(unsigned int seed)
{
	srand(seed);
}

//--------------------------------------------------------------------------------------------------------------------//

int tbMath::RandomInt(void)
{
	return rand();
}

//--------------------------------------------------------------------------------------------------------------------//

int tbMath::RandomInt(const int minimumValue, const int maximumValue)
{
	tb_error_if(minimumValue >= maximumValue, "tbExternalError: Expected minimumValue to be less than maximumValue.");
	return (RandomInt() % (maximumValue - minimumValue)) + minimumValue;
}

//--------------------------------------------------------------------------------------------------------------------//

float tbMath::RandomFloat(void)
{
	return static_cast<float>(rand()) / (static_cast<float>(RAND_MAX) + 1);
}

//--------------------------------------------------------------------------------------------------------------------//

float tbMath::RandomFloat(const float minimumValue, const float maximumValue)
{
	tb_error_if(minimumValue >= (maximumValue - kTolerance), "tbExternalError: Expected minimumValue to be less than maximumValue.");
	return (RandomFloat() * (maximumValue - minimumValue)) + minimumValue;
}

//--------------------------------------------------------------------------------------------------------------------//
