///
/// @file
/// @details This is currently in early development and will be properly documented at a later date once
///   the details are more concrete.  TODO: TIM: DocFinal: Check over interface and documentation for first public release.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrains_RandomNumbers_h_
#define _TurtleBrains_RandomNumbers_h_

#include <cmath>

#include "../core/tb_error.h"
#include "tb_constants.h"

namespace TurtleBrains
{
	namespace Math
	{

		///
		/// @details Starts the random generator with a specific seed.
		///
		void SeedRandomGenerator(unsigned int seed);

		///
		/// @details Returns a random integer between 0 and RAND_MAX by returning rand(), a better random-number
		///   generator may be used in future versions of TurtleBrains.
		///
		int RandomInt(void);

		///
		/// @details Returns a random integer between minimumValue and maximumValue inclusively.
		///
		/// @param minimumValue The smallest possible random value desired, must be less than maximumValue.
		/// @param maximumValue The largest possible random value desired, must be greater than minimumValue.
		///
		/// @note This will trigger an error condition if minimumValue is not less than the maximumValue.
		///
		int RandomInt(const int minimumValue, const int maximumValue);

		///
		/// @details Create a random float in the range of: 0.0f <= value <= 1.0f
		///
		float RandomFloat(void);

		///
		/// @details Returns a random float value between minimumValue and maximumValue inclusively.
		///
		/// @param minimumValue The smallest possible random value desired, must be less than maximumValue.
		/// @param maximumValue The largest possible random value desired, must be greater than minimumValue.
		///
		/// @note This will trigger an error condition if minimumValue is not less than the maximumValue.
		///
		float RandomFloat(const float minimumValue, const float maximumValue);

	}; /* namespace Math */
}; /* namespace TurtleBrains */

namespace tbMath = TurtleBrains::Math;

#endif /* _TurtleBrains_RandomNumbers_h_ */
