///
/// @file
/// @details The ApplicationKit header includes all classes, objects and functions that exist in TurtleBrains::Application 
///   for easy include purposes.  Instead of including each file individually, just include tb_application_kit and the rest
///   of the headers come with it.
///
/// @note Including this file may create slightly longer compile times, particularly when doing a full rebuild of a 
///   project since more files are included than are likely actually needed.  However, the easy and quick usage to get
///   up and running without worrying is worth the cost.  Internal TurtleBrains files will never include a "kit" in
///   order keep the compile times down for those who include only what is needed by their project.  This is optional.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrains_ApplicationKit_h_
#define _TurtleBrains_ApplicationKit_h_

#include "application/tb_realtime_application.h"
#include "application/tb_application_status.h"
#include "application/tb_application_menu.h"
#include "application/tb_application_dialog.h"
#include "application/tb_application_handler_interface.h"
#include "application/tb_application_input.h"

#endif /* _TurtleBrains_ApplicationKit_h_ */
