///
/// @file
/// @details The AudioKit header includes all classes, objects and functions that exist in TurtleBrains::Audio 
///   for easy include purposes.  Instead of including each file individually, just include tb_audio_kit and the rest
///   of the headers come with it.
///
/// @note Including this file may create slightly longer compile times, particularly when doing a full rebuild of a 
///   project since more files are included than are likely actually needed.  However, the easy and quick usage to get
///   up and running without worrying is worth the cost.  Internal TurtleBrains files will never include a "kit" in
///   order keep the compile times down for those who include only what is needed by their project.  This is optional.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrains_AudioKit_h_
#define _TurtleBrains_AudioKit_h_

#include "audio/tb_audio_manager.h"

#endif /* _TurtleBrains_AudioKit_h_ */
