///
/// @file
/// @details The GameKit header includes all classes, objects and functions that exist in TurtleBrains::Game 
///   for easy include purposes.  Instead of including each file individually, just include tb_game_kit and the rest
///   of the headers come with it.
///
/// @note Including this file may create slightly longer compile times, particularly when doing a full rebuild of a 
///   project since more files are included than are likely actually needed.  However, the easy and quick usage to get
///   up and running without worrying is worth the cost.  Internal TurtleBrains files will never include a "kit" in
///   order keep the compile times down for those who include only what is needed by their project.  This is optional.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrains_GameKit_h_
#define _TurtleBrains_GameKit_h_

#include "game/tb_game_scene.h"
#include "game/tb_entity.h"
#include "game/tb_entity_behavior_interface.h"
#include "game/tb_game_application.h"
#include "game/tb_tile_system.h"
#include "game/tb_game_timer.h"

#endif /* _TurtleBrains_GameKit_h_ */
