///
/// @file
/// @details The MathKit header includes all classes, objects and functions that exist in TurtleBrains::Math 
///   for easy include purposes.  Instead of including each file individually, just include tb_math_kit and the rest
///   of the headers come with it.
///
/// @note Including this file may create slightly longer compile times, particularly when doing a full rebuild of a 
///   project since more files are included than are likely actually needed.  However, the easy and quick usage to get
///   up and running without worrying is worth the cost.  Internal TurtleBrains files will never include a "kit" in
///   order keep the compile times down for those who include only what is needed by their project.  This is optional.
///
/// <!-- Copyright (c) Tim Beaudet 2016 - All Rights Reserved -->
///------------------------------------------------------------------------------------------------------------------///

#ifndef _TurtleBrains_MathKit_h_
#define _TurtleBrains_MathKit_h_

#include "math/tb_math.h"
#include "math/tb_constants.h"
#include "math/tb_vector.h"
#include "math/tb_matrix.h"
#include "math/tb_interpolation.h"
#include "math/tb_random_numbers.h"

#endif /* _TurtleBrains_MathKit_h_ */
