///
/// @file
/// @details An entity within the LudumDare35 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#include "arena_entity.h"
#include "shifter_entity.h"

//const float kArenaSize(1440.0f);
const float LudumDare35::ArenaEntity::kArenaSize(1000.0f);
const float LudumDare35::ArenaEntity::kArenaRadius(LudumDare35::ArenaEntity::kArenaSize / 2.0f);
const float LudumDare35::ArenaEntity::kArenaScale(1.0f); // kArenaSize / 64.0f);

//--------------------------------------------------------------------------------------------------------------------//

tbMath::Vector2 LudumDare35::ArenaEntity::RandomPositionNear(const tbMath::Vector2& position, float maximumDistance)
{
	tbMath::Vector2 randomDirection(tbMath::RandomFloat(-1.0f, 1.0f), tbMath::RandomFloat(-1.0f, 1.0f));
	randomDirection.Normalize();
	return position + (randomDirection * tbMath::RandomFloat(0.0f, maximumDistance));
}

//--------------------------------------------------------------------------------------------------------------------//

tbMath::Vector2 LudumDare35::ArenaEntity::RandomPositionInArena(void)
{
	tbMath::Vector2 randomDirection(tbMath::RandomFloat(-1.0f, 1.0f), tbMath::RandomFloat(-1.0f, 1.0f));
	randomDirection.Normalize();
	return randomDirection * tbMath::RandomFloat(0.0f, kArenaRadius * 0.90f);
}

//--------------------------------------------------------------------------------------------------------------------//

tbMath::Vector2 LudumDare35::ArenaEntity::GetDoorPositionInArena(const Direction& doorDirection)
{
	switch (doorDirection)
	{
	case kDirectionNorth: return tbMath::Vector2(0.0f, -kArenaRadius * 0.85f); break;
	case kDirectionSouth: return tbMath::Vector2(0.0f, kArenaRadius * 0.85f); break;
	case kDirectionWest: return tbMath::Vector2(-kArenaRadius * 0.85f, 0.0f); break;
	case kDirectionEast: return tbMath::Vector2(kArenaRadius * 0.85f, 0.0f); break;
	};
	
	//Never hit but hey,
	return tbMath::Vector2();
}

//--------------------------------------------------------------------------------------------------------------------//

LudumDare35::ArenaEntity::ArenaEntity(void) :
	tbGame::Entity("ArenaEntity"),
	//mSprite("concept_art", "solid_circle")
	mSprite("data/arena_backdrop.png")
{
	SetPosition(0.0f, 0.0f);

	//mSprite.SetColor(tbGraphics::Color(0xFF005299));
	mSprite.SetScale(kArenaScale);
	mSprite.SetOrigin(tbGraphics::kAnchorCenter);
	AddGraphic(mSprite);

	AddBoundingCircle(kArenaRadius);
}

//--------------------------------------------------------------------------------------------------------------------//

LudumDare35::ArenaEntity::~ArenaEntity(void)
{
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::ArenaEntity::OnAdded(void)
{
	tbGame::Entity::OnAdded();

	GetEntityManager()->AddEntity(new ShifterEntity(tbMath::Vector2(0.0f, 0.0f)));
	//GetEntityManager()->AddEntity(new ShifterEntity(tbMath::Vector2(-350.0f, 0.0f)));
	//GetEntityManager()->AddEntity(new ShifterEntity(tbMath::Vector2(350.0f, 0.0f)));
	//GetEntityManager()->AddEntity(new ShifterEntity(tbMath::Vector2(0.0f, -350.0f)));
	//GetEntityManager()->AddEntity(new ShifterEntity(tbMath::Vector2(0.0f, 350.0f)));
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::ArenaEntity::OnRemoved(void)
{
	tbGame::Entity::OnRemoved();
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::ArenaEntity::OnSimulate(void)
{
	tbGame::Entity::OnSimulate();
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::ArenaEntity::OnUpdate(const float deltaTime)
{
	tbGame::Entity::OnUpdate(deltaTime);
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::ArenaEntity::OnRender(void) const
{
	tbGame::Entity::OnRender();
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::ArenaEntity::OnCollideWith(tbGame::Entity& otherEntity)
{
	tbGame::Entity::OnCollideWith(otherEntity);
}

//--------------------------------------------------------------------------------------------------------------------//
