///
/// @file
/// @details An entity within the LudumDare35 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#ifndef _LudumDare35_ArenaEntity_h_
#define _LudumDare35_ArenaEntity_h_

#include "ludumdare35.h"

namespace LudumDare35
{
	enum Direction
	{
		kDirectionNorth,
		kDirectionEast,
		kDirectionSouth,
		kDirectionWest
	};

	class ArenaEntity : public tbGame::Entity
	{
	public:
		static const float kArenaSize;
		static const float kArenaRadius;

		ArenaEntity(void);
		virtual ~ArenaEntity(void);

		static tbMath::Vector2 RandomPositionInArena(void);
		static tbMath::Vector2 RandomPositionNear(const tbMath::Vector2& position, float maximumDistance = 64.0f);
		static tbMath::Vector2 GetDoorPositionInArena(const Direction& doorDirection);
		static tbMath::Vector2 GetCenterPosition(void) { return tbMath::Vector2::kZero; }

	protected:
		virtual void OnAdded(void) override;
		virtual void OnRemoved(void) override;
		virtual void OnSimulate(void) override;
		virtual void OnUpdate(const float deltaTime) override;
		virtual void OnRender(void) const override;
		virtual void OnCollideWith(tbGame::Entity& otherEntity) override;

	private:
		static const float kArenaScale;
		tbGraphics::Sprite mSprite;
	};

}; /* namespace LudumDare35 */

#endif /* _LudumDare35_ArenaEntity_h_ */
