///
/// @file
/// @details A way to store and set results, like current/best score for the LudumDare35 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#include "game_results.h"

namespace LudumDare35
{
	namespace GameResults
	{

		uint32_t theCurrentScore(0);
		uint32_t theBestScore(0);

	}; /* namespace GameResults */
}; /* namespace LudumDare35 */

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::GameResults::ResetGameResults(bool includingBest)
{
	theCurrentScore = 0;

	if (true == includingBest)
	{
		ResetBestResults();
	}
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::GameResults::ResetBestResults(void)
{
	theBestScore = 0;
}

//--------------------------------------------------------------------------------------------------------------------//

uint32_t LudumDare35::GameResults::GetCurrentScore(void)
{
	return theCurrentScore;
}

//--------------------------------------------------------------------------------------------------------------------//

uint32_t LudumDare35::GameResults::GetBestScore(void)
{
	return theBestScore;
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::GameResults::IncrementCurrentScore(const uint32_t& increaseAmount)
{
	theCurrentScore += increaseAmount;
	if (theCurrentScore > theBestScore)
	{
		theBestScore = theCurrentScore;
	}
}

//--------------------------------------------------------------------------------------------------------------------//
