///
/// @file
/// @details A way to store and set results, like current/best score for the LudumDare35 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#ifndef _LudumDare35_GameResults_h_
#define _LudumDare35_GameResults_h_

#include "ludumdare35.h"

#include <stdint.h>

namespace LudumDare35
{

	namespace GameResults
	{
		void ResetGameResults(bool includingBest);
		void ResetBestResults(void);

		uint32_t GetCurrentScore(void);
		uint32_t GetBestScore(void);

		void IncrementCurrentScore(const uint32_t& increaseAmount = 1);
	};

}; /* namespace LudumDare35 */

#endif /* _LudumDare35_GameResults_h_ */
