///
/// @file
/// @details This scene is the gameplay scene for the LudumDare35 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#ifndef _LudumDare35_GameplayScene_h_
#define _LudumDare35_GameplayScene_h_

#include "ludumdare35.h"
#include "fighter_entity.h"

namespace LudumDare35
{

	class GameplayScene : public tbGame::GameScene
	{
	public:
		GameplayScene(void);
		virtual ~GameplayScene(void);

		virtual void OnSimulate(void) override;
		virtual void OnUpdate(const float deltaTime) override;
		virtual void OnRender(void) const override;
		virtual void OnOpen(void) override;
		virtual void OnClose(void) override;

	protected:

	private:
		bool IsPlayerAlive(void);
		bool CanSpawnEnemy(void) const;
		int CountEnemiesAlive(void);
		int CountEnemiesAlive(FighterShape& fighterShape);
		
		void HandleSpawnLogic(void);
		int SpawnWaveLogic(void);

		void SpawnEnemy(const int difficulty);
		void SpawnEnemy(const FighterShape& fighterShape);
		void SpawnEnemy(const FighterShape& fighterShape, const tbMath::Vector2& spawnPosition);

		void SpawnRandomEnemy(void);
		void SpawnOpposingEnemy(void);

		int mSpawnedThisWave;
		int mWavesSpawned;
		bool mWaitingToSpawnWave;
		tbGame::GameTimer mMinimumSpawnDelayTimer;

		tbGame::GameTimer mEntryFadeInTimer;
		tbGame::GameTimer mDeathFadeOutTimer;
		tbGraphics::FullScreenQuad mBlackQuad;

		bool mShowAttackTutorial;
	};

}; /* namespace LudumDare35 */

#endif /* _LudumDare35_GameplayScene_h_ */
