///
/// @file
/// @details A way to store and set results, like current/best score for the LudumDare35 project.
///
/// <!-- Copyright (c) 2016 Tim Beaudet - All Rights Reserved -->
///-----------------------------------------------------------------------------------------------------------------///

#include "health_bar.h"

//--------------------------------------------------------------------------------------------------------------------//

LudumDare35::HealthBar::HealthBar(const int maximumHealth) :
	mOuterBox(64.0f, 12.0f, tbGraphics::Color(0xFF808080)),
	mHurtBox(60.0f, 8.0f, tbGraphics::Color(0xFFFF8080), tbMath::Vector2(2.0f, 2.0f)),
	mInnerBox(60.0f, 8.0f, tbGraphics::Color(0xFF80FF80), tbMath::Vector2(2.0f, 2.0f)),
	mMaximumHealth(maximumHealth),
	mCurrentHealth(maximumHealth)
{
	AddGraphic(mOuterBox);
	AddGraphic(mHurtBox);
	AddGraphic(mInnerBox);
}

//--------------------------------------------------------------------------------------------------------------------//

LudumDare35::HealthBar::~HealthBar(void)
{
}

//--------------------------------------------------------------------------------------------------------------------//

bool LudumDare35::HealthBar::IsAlive(void) const
{
	return (mCurrentHealth > 0) ? true : false;
}

//--------------------------------------------------------------------------------------------------------------------//

bool LudumDare35::HealthBar::Hurt(int amount)
{
	tb_error_if(amount < 0, "Cannot hurt for negative amounts, use heal instead.");
	if (amount >= mCurrentHealth)
	{
		mCurrentHealth = 0;
	}
	else
	{
		mCurrentHealth -= amount;
	}

	ResetGraphics();
	return IsAlive();
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::HealthBar::Heal(int amount)
{
	tb_error_if(amount < 0, "Cannot heal for negative amounts, use hurt instead.");
	if (mCurrentHealth + amount >= mMaximumHealth)
	{
		mCurrentHealth = mMaximumHealth;
	}
	else
	{
		mCurrentHealth += amount;
	}

	ResetGraphics();
}

//--------------------------------------------------------------------------------------------------------------------//

void LudumDare35::HealthBar::ResetGraphics(void)
{
	float healthPercentage(static_cast<float>(mCurrentHealth) / static_cast<float>(mMaximumHealth));
	mInnerBox = tbGraphics::BoxShape(60.0f * healthPercentage, 8.0f, tbGraphics::Color(0xFF80FF80), tbMath::Vector2(2.0f, 2.0f));
}

//--------------------------------------------------------------------------------------------------------------------//

